/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.requestdata;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring3.requestdata.IRequestDataValueProcessorDelegate;
import org.thymeleaf.spring3.util.SpringVersionUtils;
import org.thymeleaf.util.ClassLoaderUtils;

public final class RequestDataValueProcessorUtils {
    private static final boolean canApply;
    private static final boolean isSpring31AtLeast;
    private static final boolean isSpring40AtLeast;
    private static final String SPRING31_DELEGATE_CLASS;
    private static final IRequestDataValueProcessorDelegate spring31Delegate;
    private static final Logger LOGGER;

    public static String processAction(ITemplateContext context, String action, String httpMethod) {
        if (!canApply || !(context instanceof IWebContext)) {
            return action;
        }
        RequestContext requestContext = (RequestContext)context.getVariable("springRequestContext");
        if (requestContext == null) {
            return action;
        }
        if (spring31Delegate != null) {
            return spring31Delegate.processAction(requestContext, ((IWebContext)context).getRequest(), action, httpMethod);
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    public static String processFormFieldValue(ITemplateContext context, String name, String value, String type) {
        if (!canApply || !(context instanceof IWebContext)) {
            return value;
        }
        RequestContext requestContext = (RequestContext)context.getVariable("springRequestContext");
        if (requestContext == null) {
            return value;
        }
        if (spring31Delegate != null) {
            return spring31Delegate.processFormFieldValue(requestContext, ((IWebContext)context).getRequest(), name, value, type);
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    public static Map<String, String> getExtraHiddenFields(ITemplateContext context) {
        if (!canApply || !(context instanceof IWebContext)) {
            return null;
        }
        RequestContext requestContext = (RequestContext)context.getVariable("springRequestContext");
        if (requestContext == null) {
            return null;
        }
        if (spring31Delegate != null) {
            return spring31Delegate.getExtraHiddenFields(requestContext, ((IWebContext)context).getRequest());
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    public static String processUrl(ITemplateContext context, String url) {
        if (!canApply || !(context instanceof IWebContext)) {
            return url;
        }
        RequestContext requestContext = (RequestContext)context.getVariable("springRequestContext");
        if (requestContext == null) {
            return url;
        }
        if (spring31Delegate != null) {
            return spring31Delegate.processUrl(requestContext, ((IWebContext)context).getRequest(), url);
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    private RequestDataValueProcessorUtils() {
    }

    static {
        SPRING31_DELEGATE_CLASS = RequestDataValueProcessorUtils.class.getPackage().getName() + ".RequestDataValueProcessor31Delegate";
        LOGGER = LoggerFactory.getLogger(RequestDataValueProcessorUtils.class);
        isSpring31AtLeast = SpringVersionUtils.isSpring31AtLeast();
        isSpring40AtLeast = SpringVersionUtils.isSpring40AtLeast();
        boolean bl = canApply = isSpring31AtLeast && !isSpring40AtLeast;
        if (isSpring31AtLeast && !isSpring40AtLeast) {
            try {
                Class implClass = ClassLoaderUtils.loadClass((String)SPRING31_DELEGATE_CLASS);
                spring31Delegate = (IRequestDataValueProcessorDelegate)implClass.newInstance();
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError((Throwable)new ConfigurationException("Environment has been detected to be at least Spring 3.1, but thymeleaf could not initialize a delegate of class \"" + SPRING31_DELEGATE_CLASS + "\"", (Throwable)e));
            }
        } else {
            if (isSpring40AtLeast) {
                LOGGER.warn("[THYMELEAF] You seem to be using the thymeleaf-spring3 module with Spring version 4.x or newer. Even though most features should work OK, support for CSRF protection on websites will be disabled due to incompatibilities between the different versions of the RequestDataValueProcessor interface in versions 3.x and 4.x/newer.");
            }
            spring31Delegate = null;
        }
    }
}

