/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.util;

import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.thymeleaf.util.ContentTypeUtils;

public final class SpringContentTypeUtils {
    public static String computeViewContentType(HttpServletRequest request, String defaultContentType, Charset defaultCharset) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        String combinedContentType = ContentTypeUtils.combineContentTypeAndCharset((String)defaultContentType, (Charset)defaultCharset);
        Charset combinedCharset = ContentTypeUtils.computeCharsetFromContentType((String)combinedContentType);
        String requestPathContentType = ContentTypeUtils.computeContentTypeForRequestPath((String)request.getRequestURI(), (Charset)combinedCharset);
        if (requestPathContentType != null) {
            return requestPathContentType;
        }
        return combinedContentType;
    }

    private SpringContentTypeUtils() {
    }
}

