/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class PathTemplatePattern
extends StringValuePattern {
    private final PathTemplate pathTemplate;

    public PathTemplatePattern(@JsonProperty(value="matchesPathTemplate") String expectedValue) {
        super(expectedValue);
        this.pathTemplate = new PathTemplate(expectedValue);
    }

    public String getMatchesPathTemplate() {
        return (String)this.expectedValue;
    }

    @JsonIgnore
    public PathTemplate getPathTemplate() {
        return this.pathTemplate;
    }

    @Override
    public MatchResult match(final String path) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return PathTemplatePattern.this.pathTemplate.matches(path);
            }

            @Override
            public double getDistance() {
                if (this.isExactMatch()) {
                    return 0.0;
                }
                String expected = PathTemplatePattern.this.pathTemplate.withoutVariables();
                return Strings.normalisedLevenshteinDistance(expected, path);
            }
        };
    }
}

