/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CappDeploymentServiceImpl;
import org.wso2.carbon.application.deployer.Feature;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.application.deployer.internal.ApplicationManager;
import org.wso2.carbon.application.deployer.service.ApplicationManagerService;
import org.wso2.carbon.application.deployer.service.CappDeploymentService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="application.deployer.dscomponent", immediate=true)
public class AppDeployerServiceComponent
implements ServiceListener {
    private static RegistryService registryService;
    private static BundleContext bundleContext;
    private static ServiceRegistration appManagerRegistration;
    private static Map<String, List<Feature>> requiredFeatures;
    private List<AppDeploymentHandler> appHandlers = new ArrayList<AppDeploymentHandler>();
    private List<String> requiredServices = new ArrayList<String>();
    private ConfigurationContext configCtx;
    private static final Log log;
    private Timer pendingServicesObservationTimer = new Timer();

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            bundleContext = ctxt.getBundleContext();
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            applicationManager.init();
            appManagerRegistration = ctxt.getBundleContext().registerService(ApplicationManagerService.class.getName(), (Object)applicationManager, null);
            URL reqFeaturesResource = bundleContext.getBundle().getResource("required-features.xml");
            if (reqFeaturesResource != null) {
                InputStream xmlStream = reqFeaturesResource.openStream();
                requiredFeatures = AppDeployerUtils.readRequiredFeaturs(new StAXOMBuilder(xmlStream).getDocumentElement());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Carbon Application Deployer is activated..");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Carbon Application Deployer", e);
        }
        try {
            this.populateRequiredServices();
            if (this.requiredServices.isEmpty()) {
                this.completeInitialization(bundleContext);
            } else {
                StringBuffer ldapFilter = new StringBuffer("(|");
                for (String service : this.requiredServices) {
                    ldapFilter.append("(").append("objectClass").append("=").append(service).append(")");
                }
                ldapFilter.append(")");
                bundleContext.addServiceListener((ServiceListener)this, ldapFilter.toString());
                ServiceReference[] serviceReferences = bundleContext.getServiceReferences((String)null, ldapFilter.toString());
                if (serviceReferences != null) {
                    for (ServiceReference reference : serviceReferences) {
                        String service = ((String[])reference.getProperty("objectClass"))[0];
                        this.requiredServices.remove(service);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Removed pending service " + service));
                    }
                }
                if (this.requiredServices.isEmpty()) {
                    this.completeInitialization(bundleContext);
                } else {
                    this.schedulePendingServicesObservationTimer();
                }
            }
        }
        catch (Throwable e) {
            log.fatal((Object)"Cannot activate StartupFinalizerServiceComponent", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (appManagerRegistration != null) {
            appManagerRegistration.unregister();
        }
    }

    @Reference(name="registry.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService regService) {
        registryService = regService;
    }

    protected void unsetRegistryService(RegistryService regService) {
        registryService = null;
    }

    @Reference(name="app.handler", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetAppHandler")
    protected void setAppHandler(AppDeploymentHandler handler) {
        ApplicationManager.getInstance().registerDeploymentHandler(handler);
    }

    protected void unsetAppHandler(AppDeploymentHandler handler) {
        ApplicationManager.getInstance().unregisterDeploymentHandler(handler);
    }

    public static RegistryService getRegistryService() throws Exception {
        if (registryService == null) {
            String msg = "Before activating Carbon Application deployer bundle, an instance of RegistryService should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return registryService;
    }

    public static BundleContext getBundleContext() {
        if (bundleContext == null) {
            log.error((Object)"Application Deployer has not started. Therefore Bundle context is null");
        }
        return bundleContext;
    }

    public static Map<String, List<Feature>> getRequiredFeatures() {
        return requiredFeatures;
    }

    @Reference(name="org.wso2.carbon.configCtx", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContext")
    protected void setConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = configCtx.getServerConfigContext();
    }

    protected void unsetConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = null;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        if (serviceEvent.getType() == 1) {
            String service = ((String[])serviceEvent.getServiceReference().getProperty("objectClass"))[0];
            this.requiredServices.remove(service);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removed pending service " + service));
            }
            if (this.requiredServices.isEmpty()) {
                this.completeInitialization(bundleContext);
            }
        }
    }

    private void populateRequiredServices() {
        Bundle[] bundles;
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            String[] values;
            String requiredServiceList = (String)bundle.getHeaders().get("CAPP_MANAGER-RequiredServices");
            if (requiredServiceList == null) continue;
            for (String value : values = requiredServiceList.split(",")) {
                this.requiredServices.add(value);
            }
        }
    }

    private void schedulePendingServicesObservationTimer() {
        this.pendingServicesObservationTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!AppDeployerServiceComponent.this.requiredServices.isEmpty()) {
                    StringBuffer services = new StringBuffer();
                    for (String service : AppDeployerServiceComponent.this.requiredServices) {
                        services.append(service).append(",");
                    }
                    log.warn((Object)("Waiting for required OSGi services: " + services.toString()));
                }
            }
        }, 60000L, 60000L);
    }

    private void completeInitialization(BundleContext bundleContext) {
        this.addCAppDeployer(this.configCtx.getAxisConfiguration());
        this.registerCappdeploymentService();
    }

    public boolean addCAppDeployer(AxisConfiguration axisConfiguration) {
        boolean successfullyAdded = true;
        try {
            String appsRepo = "carbonapps";
            Class<?> deployerClass = Class.forName("org.wso2.carbon.application.deployer.CappAxis2Deployer");
            Deployer deployer = (Deployer)deployerClass.newInstance();
            deployer.setDirectory(appsRepo);
            deployer.setExtension("car");
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfiguration.getConfigurator();
            deploymentEngine.addDeployer(deployer, appsRepo, "car");
        }
        catch (Exception e) {
            successfullyAdded = false;
        }
        return successfullyAdded;
    }

    private void registerCappdeploymentService() {
        try {
            AppDeployerServiceComponent.getBundleContext().registerService(CappDeploymentService.class.getName(), (Object)new CappDeploymentServiceImpl(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Carbon CApp Services bundle is activated ");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Carbon CApp Services bundle ", e);
        }
    }

    static {
        log = LogFactory.getLog(AppDeployerServiceComponent.class);
    }
}

