/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.module.handler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class AuthorizationHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(AuthorizationHandler.class.getClass());
    private static Log audit = CarbonConstants.AUDIT_LOG;

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (this.callToGeneralService(msgContext) || this.skipAuthentication(msgContext)) {
            return Handler.InvocationResponse.CONTINUE;
        }
        if (CarbonUtils.isWorkerNode()) {
            HttpServletResponse response = (HttpServletResponse)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
            response.setStatus(403);
            log.error((Object)"Invoking admin services on worker node is forbidden...");
            return Handler.InvocationResponse.ABORT;
        }
        CarbonContext carbonCtx = CarbonContext.getThreadLocalCarbonContext();
        AxisService service = msgContext.getAxisService();
        AxisOperation operation = msgContext.getAxisOperation();
        String opName = operation.getName().getLocalPart();
        Parameter actionParam = operation.getParameter("AuthorizationAction");
        if (actionParam == null) {
            audit.warn((Object)("Unauthorized call by tenant " + carbonCtx.getTenantDomain() + ",user " + carbonCtx.getUsername() + " to service:" + service.getName() + ",operation:" + opName));
            throw new AxisFault("Unauthorized call!. AuthorizationAction has not been specified for service:" + service.getName() + ", operation:" + opName);
        }
        String serviceName = service.getName();
        try {
            String action = ((String)actionParam.getValue()).trim();
            String authzResourceId = null;
            String authzAction = null;
            if (action.startsWith("/")) {
                authzResourceId = action;
                authzAction = "ui.execute";
            }
            this.doAuthorization(msgContext, authzResourceId, authzAction, serviceName, opName);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Throwable e) {
            String msg = "System failure.";
            log.error((Object)(msg + e.getMessage()), e);
            throw new AxisFault(msg, "50978");
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void doAuthorization(MessageContext msgContext, String resourceId, String action, String serviceName, String opName) throws AxisFault {
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String username = null;
        HttpSession httpSession = request.getSession(false);
        try {
            if (httpSession != null) {
                username = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
                UserRealm realm = (UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
                if (realm == null) {
                    log.error((Object)("The realm is null for username: " + username + "."));
                    throw new AxisFault("System failed to authorize.", "50978");
                }
                resourceId = resourceId.trim();
                AuthorizationManager authMan = realm.getAuthorizationManager();
                if (!this.isAuthorized(authMan, username, resourceId, action)) {
                    log.error((Object)("Access Denied. Failed authorization attempt to access service '" + serviceName + "' operation '" + opName + "' by '" + username + "'"));
                    AxisFault afault = new AxisFault("Access Denied.");
                    afault.setFaultCode("50978");
                    throw afault;
                }
            }
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)("System failed to authorize." + e.getMessage()), (Throwable)e);
            throw new AxisFault("System failed to authorize.", "50978");
        }
    }

    private boolean isAuthorized(AuthorizationManager authManager, String username, String authString, String action) throws UserStoreException {
        String[] resourceIds;
        boolean isAuthzed = false;
        for (String resourceId : resourceIds = authString.trim().split(",")) {
            if (!authManager.isUserAuthorized(username, resourceId, action)) continue;
            isAuthzed = true;
            break;
        }
        return isAuthzed;
    }

    private boolean callToGeneralService(MessageContext msgContext) {
        boolean isGeneral = true;
        AxisService service = msgContext.getAxisService();
        Parameter param = service.getParameter("adminService");
        if (param != null && "true".equals(param.getValue())) {
            isGeneral = false;
        }
        return isGeneral;
    }

    private boolean skipAuthentication(MessageContext msgContext) {
        boolean skipAuth = false;
        AxisOperation operation = msgContext.getAxisOperation();
        Parameter param = operation.getParameter("DoAuthentication");
        if (param != null && "false".equals(param.getValue())) {
            skipAuth = true;
        }
        return skipAuth;
    }
}

