/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.service;

import java.net.SocketException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.ServerManagement;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.jdbc.dataaccess.JDBCDataAccessManager;
import org.wso2.carbon.server.admin.common.IServerAdmin;
import org.wso2.carbon.server.admin.common.ServerData;
import org.wso2.carbon.server.admin.common.ServerUpTime;
import org.wso2.carbon.server.admin.internal.ServerAdminDataHolder;
import org.wso2.carbon.server.admin.service.ServerAdminMBean;
import org.wso2.carbon.utils.Controllable;
import org.wso2.carbon.utils.NetworkUtils;

public class ServerAdmin
extends AbstractAdmin
implements ServerAdminMBean,
IServerAdmin {
    private static final Log log = LogFactory.getLog(ServerAdmin.class);
    private static final int SECONDS_PER_DAY = 86400;
    private ServerAdminDataHolder dataHolder = ServerAdminDataHolder.getInstance();

    /*
     * Unable to fully structure code
     */
    @Override
    public ServerData getServerData() throws Exception {
        isRestricted = true;
        msgContext = MessageContext.getCurrentMessageContext();
        if (msgContext != null) {
            request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            httpSession = request.getSession(false);
            if (httpSession != null) {
                userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
                isRestricted = this.getUserRealm().getAuthorizationManager().isUserAuthorized(userName, "/permission/protected/server-admin/homepage", "ui.execute") == false;
            }
        } else {
            isRestricted = false;
        }
        location = null;
        if (!isRestricted) {
            location = this.getAxisConfig().getRepository().toString();
        }
        data = new ServerData("WSO2", location, this.getTenantDomain() != null && this.getTenantDomain().equals("carbon.super") == false, isRestricted);
        if (!isRestricted) {
            systemStartTime = this.getAxisConfig().getParameter("wso2carbon.server.start.time");
            startTime = 0L;
            if (systemStartTime != null) {
                startTime = Long.parseLong((String)systemStartTime.getValue());
            }
            stTime = new Date(startTime);
            dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss");
            data.setServerStartTime(dateFormatter.format(stTime));
            data.setServerUpTime(this.getTime((System.currentTimeMillis() - startTime) / 1000L));
            systemStartUpDuration = this.getAxisConfig().getParameter("wso2carbon.startup.duration");
            if (systemStartUpDuration != null) {
                data.setServerStartUpDuration((String)systemStartUpDuration.getValue());
            }
            if ((registryType = (serverConfig = this.dataHolder.getServerConfig()).getFirstProperty("Registry.Type")) == null) {
                registryType = "embedded";
            }
            data.setRegistryType(registryType);
            dbConnection = null;
            if (registryType.equals("embedded")) {
                try {
                    dataAccessManager = RegistryContext.getBaseInstance().getDataAccessManager();
                    if (!(dataAccessManager instanceof JDBCDataAccessManager)) {
                        msg = "Failed to obtain DB connection. Invalid data access manager.";
                        ServerAdmin.log.error((Object)msg);
                        throw new AxisFault(msg);
                    }
                    dataSource = ((JDBCDataAccessManager)dataAccessManager).getDataSource();
                    dbConnection = dataSource.getConnection();
                    metaData = dbConnection.getMetaData();
                    if (metaData == null) ** GOTO lbl59
                    data.setDbName(metaData.getDatabaseProductName());
                    data.setDbVersion(metaData.getDatabaseProductVersion());
                    data.setDbDriverName(metaData.getDriverName());
                    data.setDbDriverVersion(metaData.getDriverVersion());
                    data.setDbURL(metaData.getURL());
                }
                catch (SQLException e) {
                    msg = "Cannot create DB connection";
                    ServerAdmin.log.error((Object)msg, (Throwable)e);
                    throw new AxisFault(msg, (Throwable)e);
                }
                finally {
                    if (dbConnection != null) {
                        dbConnection.close();
                    }
                }
            } else if (registryType.equals("remote")) {
                data.setRemoteRegistryChroot(serverConfig.getFirstProperty("Registry.Chroot"));
                data.setRemoteRegistryURL(serverConfig.getFirstProperty("Registry.Url"));
            }
        }
lbl59:
        // 7 sources

        try {
            data.setServerIp(NetworkUtils.getLocalHostname());
        }
        catch (SocketException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        return data;
    }

    @Override
    public String getServerDataAsString() throws Exception {
        try {
            return this.getServerData().toString();
        }
        catch (AxisFault e) {
            String msg = "Cannot get server data";
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    @Override
    public String getServerVersion() {
        return ServerConfiguration.getInstance().getFirstProperty("Version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restart() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            ConfigurationContext configurationContext = this.getConfigContext();
            final Controllable controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        controllable.restart();
                    }
                    catch (Exception e) {
                        String msg = "Cannot restart server";
                        log.error((Object)msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            };
            th.start();
            this.invalidateSession();
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restartGracefully() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            ConfigurationContext configurationContext = this.getConfigContext();
            final Controllable controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        controllable.restartGracefully();
                    }
                    catch (Exception e) {
                        String msg = "Cannot restart server";
                        log.error((Object)msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            };
            th.start();
            this.invalidateSession();
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown() throws AxisFault {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            ConfigurationContext configurationContext = this.getConfigContext();
            final Controllable controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        controllable.shutdown();
                    }
                    catch (Exception e) {
                        String msg = "Cannot shutdown server";
                        log.error((Object)msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            };
            th.start();
            this.invalidateSession();
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdownGracefully() throws AxisFault {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            ConfigurationContext configurationContext = this.getConfigContext();
            final Controllable controllable = (Controllable)configurationContext.getProperty("local_WSO2_WSAS");
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                        controllable.shutdownGracefully();
                    }
                    catch (Exception e) {
                        String msg = "Cannot gracefully shutdown server";
                        log.error((Object)msg, (Throwable)e);
                        throw new RuntimeException(msg, e);
                    }
                }
            };
            th.start();
            this.invalidateSession();
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startMaintenance() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            HashMap inTransports = this.getAxisConfig().getTransportsIn();
            new ServerManagement((Map)inTransports, this.getConfigContext()).startMaintenance();
            ServerStatus.setServerInMaintenance();
        }
        catch (AxisFault e) {
            String msg = "Cannot set server to maintenance mode";
            log.error((Object)msg, (Throwable)e);
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endMaintenance() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader originalClassloader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.dataHolder.getRestartThreadContextClassloader());
            HashMap inTransports = this.getAxisConfig().getTransportsIn();
            new ServerManagement((Map)inTransports, this.getConfigContext()).endMaintenance();
            try {
                ServerStatus.setServerRunning();
            }
            catch (AxisFault e) {
                String msg = "Cannot set server to running mode";
                log.error((Object)msg, (Throwable)e);
            }
        }
        finally {
            thread.setContextClassLoader(originalClassloader);
        }
    }

    @Override
    public boolean isAlive() {
        return true;
    }

    @Override
    public String getServerStatus() throws Exception {
        return ServerStatus.getCurrentStatus();
    }

    private void invalidateSession() {
        block4: {
            MessageContext msgCtx = MessageContext.getCurrentMessageContext();
            if (msgCtx == null) {
                return;
            }
            HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            try {
                if (request != null) {
                    request.getSession().invalidate();
                }
            }
            catch (Exception ignored) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Ignore invalidation of invalidated sessions", (Throwable)ignored);
            }
        }
    }

    private ServerUpTime getTime(long timeInSeconds) {
        long days = timeInSeconds / 86400L;
        int hours = (int)((timeInSeconds -= days * 86400L) / 3600L);
        int minutes = (int)((timeInSeconds -= (long)hours * 3600L) / 60L);
        int seconds = (int)(timeInSeconds -= (long)minutes * 60L);
        return new ServerUpTime(days, hours, minutes, seconds);
    }
}

