/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zkplus.databind.BindingGroupsListModel;
import org.zkoss.zkplus.databind.BindingListModel;
import org.zkoss.zkplus.databind.BindingListModelArray;
import org.zkoss.zkplus.databind.BindingListModelList;
import org.zkoss.zkplus.databind.BindingListModelListModel;
import org.zkoss.zkplus.databind.BindingListModelMap;
import org.zkoss.zkplus.databind.BindingListModelSet;
import org.zkoss.zkplus.databind.TypeConverter;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ext.Selectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListModelConverter
implements TypeConverter,
Serializable {
    private static final long serialVersionUID = 200808191433L;

    @Override
    public Object coerceToUi(Object val, Component comp) {
        if (val == null) {
            val = new ArrayList();
        }
        BindingListModel<Object> wrappedModel = null;
        boolean distinct = ListModelConverter.isDistinct(comp);
        if (val instanceof BindingListModel) {
            return val;
        }
        if (val instanceof ListModel) {
            wrappedModel = new BindingListModelListModel((ListModel)val, distinct);
        } else if (val instanceof Set) {
            wrappedModel = new BindingListModelSet((Set)((Object)val), true);
        } else if (val instanceof List) {
            wrappedModel = new BindingListModelList(val, true, distinct);
        } else if (val instanceof Map) {
            wrappedModel = new BindingListModelMap((Map)((Object)val), true);
        } else if (val instanceof Object[]) {
            wrappedModel = new BindingListModelArray<Object>((Object[])val, true, distinct);
        } else if (val instanceof Class && Enum.class.isAssignableFrom((Class)((Object)val))) {
            wrappedModel = new BindingListModelArray(((Class)((Object)val)).getEnumConstants(), true);
        } else if (val instanceof GroupsModel) {
            wrappedModel = new BindingGroupsListModel((GroupsModel)val);
        } else {
            throw new UiException("Expects java.util.Set, java.util.List, java.util.Map, Object[], Enum Class, GroupsModel, ListModel,or BindingListModel only. " + val.getClass());
        }
        ListModel<?> compModel = this.getComponentModel(comp);
        if (compModel instanceof Selectable && wrappedModel instanceof Selectable) {
            Selectable selectable = (Selectable)compModel;
            ((Selectable)wrappedModel).setMultiple(selectable.isMultiple());
            for (Object selected : selectable.getSelection()) {
                ((Selectable)wrappedModel).addToSelection(selected);
            }
        }
        if (!(val instanceof ListModel)) {
            wrappedModel = this.handleWrappedNonListModel(comp, wrappedModel);
        }
        return wrappedModel;
    }

    protected ListModel<?> getComponentModel(Component comp) {
        return null;
    }

    protected BindingListModel<?> handleWrappedNonListModel(Component comp, BindingListModel<?> wrappedModel) {
        return wrappedModel;
    }

    static boolean isDistinct(Component comp) {
        String distinctstr;
        Map args = (Map)comp.getAttribute("bindingArgs");
        boolean distinct = true;
        if (args != null && (distinctstr = (String)args.get("distinct")) != null) {
            distinct = Boolean.valueOf(distinctstr);
        }
        return distinct;
    }

    @Override
    public Object coerceToBean(Object val, Component comp) {
        if (val == null) {
            throw new NullPointerException("val");
        }
        if (val instanceof BindingListModelSet) {
            return ((BindingListModelSet)val).getInnerSet();
        }
        if (val instanceof BindingListModelList) {
            return ((BindingListModelList)val).getInnerList();
        }
        if (val instanceof BindingListModelMap) {
            return ((BindingListModelMap)val).getInnerMap();
        }
        if (val instanceof BindingListModelArray) {
            return ((BindingListModelArray)val).getInnerArray();
        }
        if (val instanceof BindingListModel) {
            return val;
        }
        if (val instanceof BindingListModelListModel) {
            return ((BindingListModelListModel)val).getInnerModel();
        }
        throw new UiException("Expects BindingListModelSet, BindingListModelList, BindingListModelMap, BindingListModelListModel or BindingListModel only." + val.getClass());
    }
}

