/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.theme;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public class Themes {
    private static final String THEME_COOKIE_KEY = "zktheme";
    private static final String THEME_PREFERRED_KEY = "org.zkoss.theme.preferred";
    private static final String THEME_NAMES_KEY = "org.zkoss.theme.names";
    private static final String THEME_DEFAULT_KEY = "org.zkoss.theme.default";
    private static final String THEME_PRIORITY_PREFIX = "org.zkoss.theme.priority.";
    private static final String THEME_DISPLAY_NAME_PREFIX = "org.zkoss.theme.display.";
    public static final String BREEZE_NAME = "breeze";
    public static final String BREEZE_DISPLAY = "Breeze";
    public static final int BREEZE_PRIORITY = 500;

    public static void setTheme(Execution exe, String theme) {
        Cookie cookie = new Cookie(THEME_COOKIE_KEY, theme);
        cookie.setMaxAge(2592000);
        String cp = exe.getContextPath();
        if (cp.length() == 0) {
            cp = "/";
        }
        cookie.setPath(cp);
        ((HttpServletResponse)exe.getNativeResponse()).addCookie(cookie);
    }

    public static String getTheme(Execution exe) {
        Cookie[] cookies = ((HttpServletRequest)exe.getNativeRequest()).getCookies();
        if (cookies == null) {
            return "";
        }
        for (int i = 0; i < cookies.length; ++i) {
            String theme;
            Cookie c = cookies[i];
            if (!THEME_COOKIE_KEY.equals(c.getName()) || (theme = c.getValue()) == null) continue;
            return theme;
        }
        return "";
    }

    public static String getCurrentTheme() {
        String t;
        String themes = Themes.getThemeString();
        if (Themes.contains(themes, t = Themes.getTheme(Executions.getCurrent()))) {
            return t;
        }
        t = Library.getProperty((String)THEME_PREFERRED_KEY);
        if (Themes.contains(themes, t)) {
            return t;
        }
        return Library.getProperty((String)THEME_DEFAULT_KEY);
    }

    public static boolean hasTheme(String theme) {
        return Themes.contains(Themes.getThemeString(), theme);
    }

    public static String[] getThemes() {
        return Themes.getThemeString().split(";");
    }

    public static void register(String theme) {
        String themes = Themes.getThemeString();
        if (Strings.isEmpty((String)themes)) {
            Library.setProperty((String)THEME_NAMES_KEY, (String)theme);
        } else if (!Themes.contains(themes, theme)) {
            Library.setProperty((String)THEME_NAMES_KEY, (String)(themes + ";" + theme));
        }
    }

    public static void register(String theme, String displayName, int priority) {
        Themes.register(theme);
        Themes.setDisplayName(theme, displayName);
        Themes.setPriority(theme, priority);
    }

    public static void setDisplayName(String theme, String name) {
        Library.setProperty((String)(THEME_DISPLAY_NAME_PREFIX + theme), (String)name);
    }

    public static String getDisplayName(String theme) {
        String name = Library.getProperty((String)(THEME_DISPLAY_NAME_PREFIX + theme));
        return Strings.isEmpty((String)name) ? Themes.capitalize(theme) : name;
    }

    public static void setPriority(String theme, int priority) {
        Library.setProperty((String)(THEME_PRIORITY_PREFIX + theme), (String)("" + priority));
        if (Themes.getPriority(Library.getProperty((String)THEME_DEFAULT_KEY)) >= priority) {
            Library.setProperty((String)THEME_DEFAULT_KEY, (String)theme);
        }
    }

    public static int getPriority(String theme) {
        return Library.getIntProperty((String)(THEME_PRIORITY_PREFIX + theme), (int)Integer.MAX_VALUE);
    }

    private static String getThemeString() {
        return Library.getProperty((String)THEME_NAMES_KEY, (String)"");
    }

    private static boolean contains(String themes, String target) {
        return !Strings.isEmpty((String)target) && (";" + themes + ";").indexOf(";" + target + ";") != -1;
    }

    private static String capitalize(String str) {
        if (Strings.isEmpty((String)str)) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

