/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto;

import java.util.Objects;
import pl.allegro.finance.tradukisto.internal.Container;
import pl.allegro.finance.tradukisto.internal.LongToStringConverter;

public enum LongValueConverters {
    AZERBAIJANI_LONG(Container.azerbaijaniContainer().getLongConverter()),
    CROATIAN_LONG(Container.croatianContainer().getLongConverter()),
    ENGLISH_LONG(Container.englishContainer().getLongConverter()),
    RUSSIAN_LONG(Container.russianContainer().getLongConverter()),
    POLISH_LONG(Container.polishContainer().getLongConverter()),
    HINDI_LONG(Container.hindiContainer().getLongConverter()),
    SWEDISH_LONG(Container.swedishContainer().getLongConverter()),
    JAPANESE_KANJI_LONG(Container.japaneseKanjiContainer().getLongConverter()),
    DUTCH_LONG(Container.dutchContainer().getLongConverter());

    private final LongToStringConverter converter;

    private LongValueConverters(LongToStringConverter converter) {
        this.converter = converter;
    }

    public String asWords(Long value) {
        Objects.requireNonNull(value);
        return this.converter.asWords(value);
    }
}

