/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal;

import java.util.ArrayList;
import java.util.List;
import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.ToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;

public class NumberProcessor {
    private final IntegerToStringConverter bigNumbersConverter;
    private final GenderAwareIntegerToStringConverter smallNumbersConverter;

    public NumberProcessor(IntegerToStringConverter bigNumbersConverter, IntegerToStringConverter smallNumbersConverter) {
        this.bigNumbersConverter = bigNumbersConverter;
        this.smallNumbersConverter = ToStringConverter.toGenderAwareInteger(smallNumbersConverter);
    }

    public NumberProcessor(IntegerToStringConverter bigNumbersConverter, GenderAwareIntegerToStringConverter smallNumbersConverter) {
        this.bigNumbersConverter = bigNumbersConverter;
        this.smallNumbersConverter = smallNumbersConverter;
    }

    public String process(Integer bigNumber, Integer smallNumber) {
        ArrayList<String> result = new ArrayList<String>();
        if (bigNumber > 0) {
            result.add(this.bigNumbersConverter.asWords(bigNumber));
        }
        if (smallNumber > 0) {
            result.add(this.smallNumbersConverter.asWords(smallNumber, GenderType.NON_APPLICABLE));
        }
        return this.merge(result);
    }

    private String merge(List<String> result) {
        return result.isEmpty() ? this.smallNumbersConverter.asWords(0, GenderType.NON_APPLICABLE) : String.join((CharSequence)" ", result);
    }
}

