/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.czech;

import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class CzechPluralForms
implements PluralForms {
    private final String singularForm;
    private final String pluralForm;
    private final String genitivePluralForm;
    private final GenderType genderType;

    public CzechPluralForms(String singularForm, String pluralForm, String genitivePluralForm, GenderType genderType) {
        this.singularForm = singularForm;
        this.pluralForm = pluralForm;
        this.genitivePluralForm = genitivePluralForm;
        this.genderType = genderType;
    }

    public CzechPluralForms() {
        this("", "", "", GenderType.NON_APPLICABLE);
    }

    @Override
    public String formFor(Integer value) {
        if (value == 1) {
            return this.singularForm;
        }
        if (Range.closed(2, 4).contains(value)) {
            return this.pluralForm;
        }
        return this.genitivePluralForm;
    }

    @Override
    public GenderType genderType() {
        return this.genderType;
    }
}

