/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.greek;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.LongToStringConverter;
import pl.allegro.finance.tradukisto.internal.NumberProcessor;

public class GreekIntegerToWordsConverter
implements IntegerToStringConverter,
LongToStringConverter {
    private final Map<Integer, String> exceptions;
    private final NumberProcessor numberProcessor;

    public GreekIntegerToWordsConverter(IntegerToStringConverter bigNumbersConverter, IntegerToStringConverter smallNumbersConverter, Map<Integer, String> exceptions) {
        this.numberProcessor = new NumberProcessor(bigNumbersConverter, smallNumbersConverter);
        this.exceptions = exceptions;
    }

    @Override
    public String asWords(Integer value) {
        if (this.exceptions.containsKey(value)) {
            return this.exceptions.get(value);
        }
        Integer bigNumber = value / 1000;
        Integer smallNumber = value % 1000;
        return this.numberProcessor.process(bigNumber, smallNumber);
    }

    @Override
    public String asWords(Long value) {
        if (this.exceptions.containsKey(value)) {
            return this.exceptions.get(value);
        }
        Integer bigNumber = value.intValue() / 1000;
        Integer smallNumber = value.intValue() % 1000;
        return this.numberProcessor.process(bigNumber, smallNumber);
    }
}

