/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.hindi;

import java.util.List;
import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.converters.NumberToWordsConverter;
import pl.allegro.finance.tradukisto.internal.languages.PluralForms;
import pl.allegro.finance.tradukisto.internal.support.Assert;
import pl.allegro.finance.tradukisto.internal.support.IndianNumberChunking;
import pl.allegro.finance.tradukisto.internal.support.NumberChunking;

public class IndianNumberToWordsConverter
extends NumberToWordsConverter {
    private final NumberChunking numberChunking = new IndianNumberChunking();

    public IndianNumberToWordsConverter(GenderAwareIntegerToStringConverter hundredsToWordsConverter, List<PluralForms> pluralForms) {
        super(hundredsToWordsConverter, pluralForms);
    }

    @Override
    public String asWords(Long value) {
        Assert.isTrue(value >= 0L, () -> String.format("can't convert negative numbers for value %d", value));
        List<Integer> valueChunks = this.numberChunking.chunk(value);
        List<PluralForms> formsToUse = this.getRequiredFormsInReversedOrder(valueChunks.size());
        return this.joinValueChunksWithForms(valueChunks.iterator(), formsToUse.iterator());
    }
}

