/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.hungarian;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.GenderForms;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class HungarianThousandToWordsConverter
implements GenderAwareIntegerToStringConverter {
    private final Map<Integer, GenderForms> baseValues;

    public HungarianThousandToWordsConverter(Map<Integer, GenderForms> baseValues) {
        this.baseValues = baseValues;
    }

    @Override
    public String asWords(Integer value, GenderType genderType) {
        if (this.baseValues.containsKey(value)) {
            return this.baseValues.get(value).formFor(genderType);
        }
        if (Range.closed(21, 99).contains(value)) {
            return this.twoDigitsNumberAsString(value, genderType);
        }
        if (Range.closed(101, 999).contains(value)) {
            return this.threeDigitsNumberAsString(value, genderType);
        }
        if (Range.closed(1000, 999999).contains(value)) {
            return this.thousandsAsString(value, genderType);
        }
        throw new IllegalArgumentException(String.format("Can't convert %d", value));
    }

    private String twoDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer units = value % 10;
        Integer tens = value - units;
        String tensWord = this.getTensPrefix(tens);
        String unitsWord = this.asWords(units, genderType);
        return tensWord + unitsWord;
    }

    private String getTensPrefix(Integer tens) {
        switch (tens) {
            case 20: {
                return "huszon";
            }
            case 30: {
                return "harminc";
            }
            case 40: {
                return "negyven";
            }
            case 50: {
                return "\u00f6tven";
            }
            case 60: {
                return "hatvan";
            }
            case 70: {
                return "hetven";
            }
            case 80: {
                return "nyolcvan";
            }
            case 90: {
                return "kilencven";
            }
        }
        throw new IllegalArgumentException("Invalid tens value: " + tens);
    }

    private String threeDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer tensWithUnits = value % 100;
        Integer hundreds = value - tensWithUnits;
        return String.format("%s%s", this.asWords(hundreds, genderType), this.asWords(tensWithUnits, genderType));
    }

    private String thousandsAsString(Integer value, GenderType genderType) {
        Integer thousands = value / 1000;
        Integer other = value % 1000;
        String thousandsWord = this.getThousandsPrefix(thousands, genderType);
        if (other == 0) {
            return thousandsWord;
        }
        return String.format("%s%s", thousandsWord, this.asWords(other, genderType));
    }

    private String getThousandsPrefix(Integer thousands, GenderType genderType) {
        if (thousands == 1) {
            return "ezer";
        }
        if (thousands == 2) {
            return "k\u00e9tezer";
        }
        return this.asWords(thousands, genderType) + "ezer";
    }
}

