/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.japanese;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.GenderForms;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class JapaneseThousandToWordsConverter
implements IntegerToStringConverter {
    private final Map<Integer, GenderForms> baseValues;

    public JapaneseThousandToWordsConverter(Map<Integer, GenderForms> baseValues) {
        this.baseValues = baseValues;
    }

    @Override
    public String asWords(Integer value) {
        if (this.baseValues.containsKey(value)) {
            return this.baseValues.get(value).formFor(GenderType.NON_APPLICABLE);
        }
        if (Range.closed(11, 99).contains(value)) {
            return this.twoDigitsNumberAsString(value);
        }
        if (Range.closed(101, 999).contains(value)) {
            return this.threeDigitsNumberAsString(value);
        }
        if (Range.closed(1001, 9999).contains(value)) {
            return this.fourDigitsNumberAsString(value);
        }
        throw new IllegalArgumentException(String.format("Can't convert %d", value));
    }

    private String twoDigitsNumberAsString(Integer value) {
        Integer units = value % 10;
        Integer tens = value - units;
        return String.format("%s%s", this.asWords(tens), this.asWords(units));
    }

    private String threeDigitsNumberAsString(Integer value) {
        Integer units = value % 100;
        Integer hundreds = value - units;
        return String.format("%s%s", this.asWords(hundreds), this.asWords(units));
    }

    private String fourDigitsNumberAsString(Integer value) {
        Integer units = value % 1000;
        Integer thousands = value - units;
        return String.format("%s%s", this.asWords(thousands), this.asWords(units));
    }
}

