/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.portuguese;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.MultiFormNumber;
import pl.allegro.finance.tradukisto.internal.languages.GenderForms;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class PortugueseThousandToWordsConverter
implements IntegerToStringConverter {
    private static final boolean HAS_NEXT_VALUE = true;
    private static final boolean HAS_NOT_NEXT_VALUE = false;
    private static final int HUNDRED = 100;
    private final Map<Integer, GenderForms> baseValues;
    private final Map<Integer, MultiFormNumber> exceptions;
    private final GenderType genderType = GenderType.NON_APPLICABLE;

    public PortugueseThousandToWordsConverter(Map<Integer, GenderForms> baseValues, Map<Integer, MultiFormNumber> exceptions) {
        this.baseValues = baseValues;
        this.exceptions = exceptions;
    }

    @Override
    public String asWords(Integer value) {
        return this.asWords(value, false);
    }

    private String asWords(Integer value, boolean hasNextNumber) {
        if (this.baseValues.containsKey(value)) {
            return this.baseValues.get(value).formFor(this.genderType);
        }
        if (this.exceptions.containsKey(value)) {
            return hasNextNumber ? this.exceptions.get(value).getRegularForm() : this.exceptions.get(value).getAloneForm();
        }
        if (Range.closed(21, 99).contains(value)) {
            return this.twoDigitsNumberAsString(value);
        }
        if (Range.closed(101, 999).contains(value)) {
            return this.threeDigitsNumberAsString(value);
        }
        if (Range.closed(1000, 999999).contains(value)) {
            return this.thousandsAsString(value);
        }
        throw new IllegalArgumentException(String.format("Can't convert %d", value));
    }

    private String twoDigitsNumberAsString(Integer value) {
        Integer units = value % 10;
        Integer tens = value - units;
        return String.format("%s e %s", this.asWords(tens), this.asWords(units));
    }

    private String threeDigitsNumberAsString(Integer value) {
        Integer tensWithUnits = value % 100;
        Integer hundreds = value - tensWithUnits;
        return String.format("%s e %s", this.asWords(hundreds, true), this.asWords(tensWithUnits));
    }

    private String thousandsAsString(Integer value) {
        Integer thousands = value / 1000;
        Integer other = value % 1000;
        if (this.isOneThousand(thousands)) {
            return this.getOneThousandAsWords(other);
        }
        return this.getThousandsAsWords(thousands, other);
    }

    private String getThousandsAsWords(Integer thousands, Integer other) {
        if (this.nothingComesAfter(other)) {
            return String.format("%s mil", this.asWords(thousands));
        }
        if (other == 100) {
            return String.format("%s mil e %s", this.asWords(thousands, false), this.asWords(other, false));
        }
        return String.format("%s mil %s", this.asWords(thousands), this.asWords(other, true));
    }

    private String getOneThousandAsWords(Integer other) {
        if (this.nothingComesAfter(other)) {
            return "mil";
        }
        if (other == 100) {
            return String.format("mil e %s", this.asWords(other, false));
        }
        return String.format("mil %s", this.asWords(other, true));
    }

    private boolean nothingComesAfter(Integer other) {
        return other == 0;
    }

    private boolean isOneThousand(Integer thousands) {
        return thousands == 1;
    }
}

