/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.spanish;

import java.math.BigDecimal;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.converters.BigDecimalToBankingMoneyConverter;

public class SpanishBigDecimalToBankingMoneyConverter
extends BigDecimalToBankingMoneyConverter {
    private static final String FORMAT = "%s %s %02d/100";
    private final IntegerToStringConverter converter;

    public SpanishBigDecimalToBankingMoneyConverter(IntegerToStringConverter converter, String currencySymbol) {
        super(converter, currencySymbol);
        this.converter = converter;
    }

    @Override
    public String asWords(BigDecimal value, String currencySymbol) {
        this.validate(value);
        Integer units = value.intValue();
        Integer subunits = value.remainder(BigDecimal.ONE).multiply(new BigDecimal(100)).intValue();
        String words = this.converter.asWords(units);
        if (words.endsWith("uno")) {
            words = words.replaceAll("uno$", "un");
        }
        return String.format(FORMAT, words, currencySymbol, subunits);
    }
}

