/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.spanish;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.IntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.MultiFormNumber;
import pl.allegro.finance.tradukisto.internal.NumberProcessor;

public class SpanishIntegerToWordsConverter
implements IntegerToStringConverter {
    private final IntegerToStringConverter bigNumbersConverter;
    private final Map<Integer, MultiFormNumber> exceptions;
    private final IntegerToStringConverter smallNumbersConverter;

    public SpanishIntegerToWordsConverter(IntegerToStringConverter bigNumbersConverter, Map<Integer, MultiFormNumber> exceptions, IntegerToStringConverter smallNumbersConverter) {
        this.bigNumbersConverter = bigNumbersConverter;
        this.exceptions = exceptions;
        this.smallNumbersConverter = smallNumbersConverter;
    }

    @Override
    public String asWords(Integer value) {
        if (this.exceptions.containsKey(value)) {
            return this.exceptions.get(value).getAloneForm();
        }
        Integer bigNumber = value / 1000000;
        Integer smallNumber = value % 1000000;
        Object numberProcessor = new NumberProcessor(this.bigNumbersConverter, this.smallNumbersConverter).process(bigNumber, smallNumber);
        if (value.toString().endsWith("1") && !value.toString().endsWith("11")) {
            numberProcessor = (String)numberProcessor + "o";
        }
        if (value == 1000000000) {
            numberProcessor = "mil millones";
        }
        if (value > 1000000000) {
            numberProcessor = ((String)numberProcessor).replace("un mil millones", "mil");
        }
        if (value == 2000000000) {
            numberProcessor = "dos mil millones";
        }
        if (value > 2000000000) {
            numberProcessor = ((String)numberProcessor).replace("un mill\u00f3n", "un millones").replace("dos mil millones", "dos mil");
        }
        return numberProcessor;
    }
}

