/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.finance.tradukisto.internal.languages.swedish;

import java.util.Map;
import pl.allegro.finance.tradukisto.internal.GenderAwareIntegerToStringConverter;
import pl.allegro.finance.tradukisto.internal.languages.GenderForms;
import pl.allegro.finance.tradukisto.internal.languages.GenderType;
import pl.allegro.finance.tradukisto.internal.support.Range;

public class SwedishHundredToWordsConverter
implements GenderAwareIntegerToStringConverter {
    private final Map<Integer, GenderForms> swedishBaseValues;

    public SwedishHundredToWordsConverter(Map<Integer, GenderForms> swedishBaseValues) {
        this.swedishBaseValues = swedishBaseValues;
    }

    @Override
    public String asWords(Integer value, GenderType swedishGenderType) {
        if (this.swedishBaseValues.containsKey(value)) {
            return this.swedishBaseValues.get(value).formFor(swedishGenderType);
        }
        if (Range.closed(21, 99).contains(value)) {
            return this.twoDigitsNumberAsString(value, swedishGenderType);
        }
        if (Range.closed(101, 999).contains(value)) {
            return this.threeDigitsNumberAsString(value, swedishGenderType);
        }
        throw new IllegalArgumentException(String.format("Can't convert %d", value));
    }

    private String twoDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer units = value % 10;
        Integer tens = value - units;
        return String.format("%s%s", this.asWords(tens, genderType), this.asWords(units, genderType));
    }

    private String threeDigitsNumberAsString(Integer value, GenderType genderType) {
        Integer tensWithUnits = value % 100;
        Integer hundreds = value - tensWithUnits;
        return String.format("%s och %s", this.asWords(hundreds, genderType), this.asWords(tensWithUnits, genderType));
    }
}

