/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.audit.entity;

import java.time.Clock;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.SQLInsert;

@Table(name="audit")
@Entity
@SQLInsert(sql="insert into audit.audit (object_name, object_type, source_application, audit_type_id, context, creation_date, event_date, event_type, hostname, object_id, receiver_id, sender_id, source_workstation, user_id, username, id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)")
public class AuditEntity {
    @Id
    @Access(value=AccessType.PROPERTY)
    @Column(name="id", nullable=false)
    private UUID id;
    @Column(name="id", insertable=false, updatable=false)
    @ColumnTransformer(read="id::text")
    private String idAsText;
    @Column(name="event_date", nullable=false)
    private LocalDateTime eventDate;
    @Column(name="event_type", nullable=false)
    private String eventType;
    @Column(name="object_type")
    private String auditObjectType;
    @Column(name="object_name")
    private String auditObjectName;
    @Column(name="object_id")
    private String objectId;
    @Column(name="user_id")
    private String userId;
    @Column(name="username")
    private String username;
    @Column(name="source_application")
    private String auditSourceApplication;
    @Column(name="source_workstation")
    private String sourceWorkstation;
    @Column(name="context", nullable=false)
    private String context;
    @Column(name="creation_date", nullable=false)
    private LocalDateTime creationDate;
    @Column(name="hostname")
    private String hostname;
    @Column(name="audit_type_id")
    private Short auditTypeId;
    @Column(name="sender_id")
    private String senderId;
    @Column(name="receiver_id")
    private String receiverId;

    @PrePersist
    public void prePersist() {
        this.id = this.id == null ? UUID.randomUUID() : this.id;
        this.creationDate = this.creationDate == null ? LocalDateTime.now(Clock.systemUTC()) : this.creationDate;
    }

    public static AuditEntityBuilder builder() {
        return new AuditEntityBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public String getIdAsText() {
        return this.idAsText;
    }

    public LocalDateTime getEventDate() {
        return this.eventDate;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getAuditObjectType() {
        return this.auditObjectType;
    }

    public String getAuditObjectName() {
        return this.auditObjectName;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getAuditSourceApplication() {
        return this.auditSourceApplication;
    }

    public String getSourceWorkstation() {
        return this.sourceWorkstation;
    }

    public String getContext() {
        return this.context;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Short getAuditTypeId() {
        return this.auditTypeId;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setIdAsText(String idAsText) {
        this.idAsText = idAsText;
    }

    public void setEventDate(LocalDateTime eventDate) {
        this.eventDate = eventDate;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setAuditObjectType(String auditObjectType) {
        this.auditObjectType = auditObjectType;
    }

    public void setAuditObjectName(String auditObjectName) {
        this.auditObjectName = auditObjectName;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAuditSourceApplication(String auditSourceApplication) {
        this.auditSourceApplication = auditSourceApplication;
    }

    public void setSourceWorkstation(String sourceWorkstation) {
        this.sourceWorkstation = sourceWorkstation;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setAuditTypeId(Short auditTypeId) {
        this.auditTypeId = auditTypeId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    public AuditEntity() {
    }

    public AuditEntity(UUID id, String idAsText, LocalDateTime eventDate, String eventType, String auditObjectType, String auditObjectName, String objectId, String userId, String username, String auditSourceApplication, String sourceWorkstation, String context, LocalDateTime creationDate, String hostname, Short auditTypeId, String senderId, String receiverId) {
        this.id = id;
        this.idAsText = idAsText;
        this.eventDate = eventDate;
        this.eventType = eventType;
        this.auditObjectType = auditObjectType;
        this.auditObjectName = auditObjectName;
        this.objectId = objectId;
        this.userId = userId;
        this.username = username;
        this.auditSourceApplication = auditSourceApplication;
        this.sourceWorkstation = sourceWorkstation;
        this.context = context;
        this.creationDate = creationDate;
        this.hostname = hostname;
        this.auditTypeId = auditTypeId;
        this.senderId = senderId;
        this.receiverId = receiverId;
    }

    public String toString() {
        return "AuditEntity(id=" + this.getId() + ", idAsText=" + this.getIdAsText() + ", eventDate=" + this.getEventDate() + ", eventType=" + this.getEventType() + ", auditObjectType=" + this.getAuditObjectType() + ", auditObjectName=" + this.getAuditObjectName() + ", objectId=" + this.getObjectId() + ", userId=" + this.getUserId() + ", username=" + this.getUsername() + ", auditSourceApplication=" + this.getAuditSourceApplication() + ", sourceWorkstation=" + this.getSourceWorkstation() + ", context=" + this.getContext() + ", creationDate=" + this.getCreationDate() + ", hostname=" + this.getHostname() + ", auditTypeId=" + this.getAuditTypeId() + ", senderId=" + this.getSenderId() + ", receiverId=" + this.getReceiverId() + ")";
    }

    public static class AuditEntityBuilder {
        private UUID id;
        private String idAsText;
        private LocalDateTime eventDate;
        private String eventType;
        private String auditObjectType;
        private String auditObjectName;
        private String objectId;
        private String userId;
        private String username;
        private String auditSourceApplication;
        private String sourceWorkstation;
        private String context;
        private LocalDateTime creationDate;
        private String hostname;
        private Short auditTypeId;
        private String senderId;
        private String receiverId;

        AuditEntityBuilder() {
        }

        public AuditEntityBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public AuditEntityBuilder idAsText(String idAsText) {
            this.idAsText = idAsText;
            return this;
        }

        public AuditEntityBuilder eventDate(LocalDateTime eventDate) {
            this.eventDate = eventDate;
            return this;
        }

        public AuditEntityBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public AuditEntityBuilder auditObjectType(String auditObjectType) {
            this.auditObjectType = auditObjectType;
            return this;
        }

        public AuditEntityBuilder auditObjectName(String auditObjectName) {
            this.auditObjectName = auditObjectName;
            return this;
        }

        public AuditEntityBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public AuditEntityBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AuditEntityBuilder username(String username) {
            this.username = username;
            return this;
        }

        public AuditEntityBuilder auditSourceApplication(String auditSourceApplication) {
            this.auditSourceApplication = auditSourceApplication;
            return this;
        }

        public AuditEntityBuilder sourceWorkstation(String sourceWorkstation) {
            this.sourceWorkstation = sourceWorkstation;
            return this;
        }

        public AuditEntityBuilder context(String context) {
            this.context = context;
            return this;
        }

        public AuditEntityBuilder creationDate(LocalDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public AuditEntityBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public AuditEntityBuilder auditTypeId(Short auditTypeId) {
            this.auditTypeId = auditTypeId;
            return this;
        }

        public AuditEntityBuilder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public AuditEntityBuilder receiverId(String receiverId) {
            this.receiverId = receiverId;
            return this;
        }

        public AuditEntity build() {
            return new AuditEntity(this.id, this.idAsText, this.eventDate, this.eventType, this.auditObjectType, this.auditObjectName, this.objectId, this.userId, this.username, this.auditSourceApplication, this.sourceWorkstation, this.context, this.creationDate, this.hostname, this.auditTypeId, this.senderId, this.receiverId);
        }

        public String toString() {
            return "AuditEntity.AuditEntityBuilder(id=" + this.id + ", idAsText=" + this.idAsText + ", eventDate=" + this.eventDate + ", eventType=" + this.eventType + ", auditObjectType=" + this.auditObjectType + ", auditObjectName=" + this.auditObjectName + ", objectId=" + this.objectId + ", userId=" + this.userId + ", username=" + this.username + ", auditSourceApplication=" + this.auditSourceApplication + ", sourceWorkstation=" + this.sourceWorkstation + ", context=" + this.context + ", creationDate=" + this.creationDate + ", hostname=" + this.hostname + ", auditTypeId=" + this.auditTypeId + ", senderId=" + this.senderId + ", receiverId=" + this.receiverId + ")";
        }
    }
}

