/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.connect;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.connect.CfnInstanceStorageConfig;
import software.amazon.awscdk.services.connect.CfnInstanceStorageConfigProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_connect.CfnInstanceStorageConfig")
public class CfnInstanceStorageConfig
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInstanceStorageConfig.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnInstanceStorageConfig(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstanceStorageConfig(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInstanceStorageConfig(@NotNull Construct scope, @NotNull String id, @NotNull CfnInstanceStorageConfigProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrAssociationId() {
        return (String)Kernel.get((Object)this, (String)"attrAssociationId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getInstanceArn() {
        return (String)Kernel.get((Object)this, (String)"instanceArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setInstanceArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"instanceArn", (Object)Objects.requireNonNull(value, "instanceArn is required"));
    }

    @NotNull
    public String getResourceType() {
        return (String)Kernel.get((Object)this, (String)"resourceType", (NativeType)NativeType.forClass(String.class));
    }

    public void setResourceType(@NotNull String value) {
        Kernel.set((Object)this, (String)"resourceType", (Object)Objects.requireNonNull(value, "resourceType is required"));
    }

    @NotNull
    public String getStorageType() {
        return (String)Kernel.get((Object)this, (String)"storageType", (NativeType)NativeType.forClass(String.class));
    }

    public void setStorageType(@NotNull String value) {
        Kernel.set((Object)this, (String)"storageType", (Object)Objects.requireNonNull(value, "storageType is required"));
    }

    @Nullable
    public Object getKinesisFirehoseConfig() {
        return Kernel.get((Object)this, (String)"kinesisFirehoseConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKinesisFirehoseConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"kinesisFirehoseConfig", (Object)value);
    }

    public void setKinesisFirehoseConfig(@Nullable KinesisFirehoseConfigProperty value) {
        Kernel.set((Object)this, (String)"kinesisFirehoseConfig", (Object)value);
    }

    @Nullable
    public Object getKinesisStreamConfig() {
        return Kernel.get((Object)this, (String)"kinesisStreamConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKinesisStreamConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"kinesisStreamConfig", (Object)value);
    }

    public void setKinesisStreamConfig(@Nullable KinesisStreamConfigProperty value) {
        Kernel.set((Object)this, (String)"kinesisStreamConfig", (Object)value);
    }

    @Nullable
    public Object getKinesisVideoStreamConfig() {
        return Kernel.get((Object)this, (String)"kinesisVideoStreamConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKinesisVideoStreamConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"kinesisVideoStreamConfig", (Object)value);
    }

    public void setKinesisVideoStreamConfig(@Nullable KinesisVideoStreamConfigProperty value) {
        Kernel.set((Object)this, (String)"kinesisVideoStreamConfig", (Object)value);
    }

    @Nullable
    public Object getS3Config() {
        return Kernel.get((Object)this, (String)"s3Config", (NativeType)NativeType.forClass(Object.class));
    }

    public void setS3Config(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"s3Config", (Object)value);
    }

    public void setS3Config(@Nullable S3ConfigProperty value) {
        Kernel.set((Object)this, (String)"s3Config", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnInstanceStorageConfig> {
        private final Construct scope;
        private final String id;
        private final CfnInstanceStorageConfigProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnInstanceStorageConfigProps.Builder();
        }

        public Builder instanceArn(String instanceArn) {
            this.props.instanceArn(instanceArn);
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.props.resourceType(resourceType);
            return this;
        }

        public Builder storageType(String storageType) {
            this.props.storageType(storageType);
            return this;
        }

        public Builder kinesisFirehoseConfig(IResolvable kinesisFirehoseConfig) {
            this.props.kinesisFirehoseConfig(kinesisFirehoseConfig);
            return this;
        }

        public Builder kinesisFirehoseConfig(KinesisFirehoseConfigProperty kinesisFirehoseConfig) {
            this.props.kinesisFirehoseConfig(kinesisFirehoseConfig);
            return this;
        }

        public Builder kinesisStreamConfig(IResolvable kinesisStreamConfig) {
            this.props.kinesisStreamConfig(kinesisStreamConfig);
            return this;
        }

        public Builder kinesisStreamConfig(KinesisStreamConfigProperty kinesisStreamConfig) {
            this.props.kinesisStreamConfig(kinesisStreamConfig);
            return this;
        }

        public Builder kinesisVideoStreamConfig(IResolvable kinesisVideoStreamConfig) {
            this.props.kinesisVideoStreamConfig(kinesisVideoStreamConfig);
            return this;
        }

        public Builder kinesisVideoStreamConfig(KinesisVideoStreamConfigProperty kinesisVideoStreamConfig) {
            this.props.kinesisVideoStreamConfig(kinesisVideoStreamConfig);
            return this;
        }

        public Builder s3Config(IResolvable s3Config) {
            this.props.s3Config(s3Config);
            return this;
        }

        public Builder s3Config(S3ConfigProperty s3Config) {
            this.props.s3Config(s3Config);
            return this;
        }

        public CfnInstanceStorageConfig build() {
            return new CfnInstanceStorageConfig(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_connect.CfnInstanceStorageConfig.S3ConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3ConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        @NotNull
        public String getBucketPrefix();

        @Nullable
        default public Object getEncryptionConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3ConfigProperty> {
            String bucketName;
            String bucketPrefix;
            Object encryptionConfig;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder bucketPrefix(String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            public Builder encryptionConfig(IResolvable encryptionConfig) {
                this.encryptionConfig = encryptionConfig;
                return this;
            }

            public Builder encryptionConfig(EncryptionConfigProperty encryptionConfig) {
                this.encryptionConfig = encryptionConfig;
                return this;
            }

            public S3ConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_connect.CfnInstanceStorageConfig.KinesisVideoStreamConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisVideoStreamConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getPrefix();

        @NotNull
        public Number getRetentionPeriodHours();

        @Nullable
        default public Object getEncryptionConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisVideoStreamConfigProperty> {
            String prefix;
            Number retentionPeriodHours;
            Object encryptionConfig;

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public Builder retentionPeriodHours(Number retentionPeriodHours) {
                this.retentionPeriodHours = retentionPeriodHours;
                return this;
            }

            public Builder encryptionConfig(IResolvable encryptionConfig) {
                this.encryptionConfig = encryptionConfig;
                return this;
            }

            public Builder encryptionConfig(EncryptionConfigProperty encryptionConfig) {
                this.encryptionConfig = encryptionConfig;
                return this;
            }

            public KinesisVideoStreamConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_connect.CfnInstanceStorageConfig.KinesisStreamConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisStreamConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getStreamArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisStreamConfigProperty> {
            String streamArn;

            public Builder streamArn(String streamArn) {
                this.streamArn = streamArn;
                return this;
            }

            public KinesisStreamConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_connect.CfnInstanceStorageConfig.KinesisFirehoseConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KinesisFirehoseConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getFirehoseArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KinesisFirehoseConfigProperty> {
            String firehoseArn;

            public Builder firehoseArn(String firehoseArn) {
                this.firehoseArn = firehoseArn;
                return this;
            }

            public KinesisFirehoseConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_connect.CfnInstanceStorageConfig.EncryptionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getEncryptionType();

        @NotNull
        public String getKeyId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionConfigProperty> {
            String encryptionType;
            String keyId;

            public Builder encryptionType(String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            public Builder keyId(String keyId) {
                this.keyId = keyId;
                return this;
            }

            public EncryptionConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

