/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the backends that a virtual node is expected to send outbound traffic to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Backend implements SdkPojo, Serializable, ToCopyableBuilder<Backend.Builder, Backend> {
    private static final SdkField<VirtualServiceBackend> VIRTUAL_SERVICE_FIELD = SdkField
            .<VirtualServiceBackend> builder(MarshallingType.SDK_POJO).getter(getter(Backend::virtualService))
            .setter(setter(Builder::virtualService)).constructor(VirtualServiceBackend::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualService").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_SERVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualServiceBackend virtualService;

    private Backend(BuilderImpl builder) {
        this.virtualService = builder.virtualService;
    }

    /**
     * <p>
     * Specifies a virtual service to use as a backend for a virtual node.
     * </p>
     * 
     * @return Specifies a virtual service to use as a backend for a virtual node.
     */
    public VirtualServiceBackend virtualService() {
        return virtualService;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualService());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backend)) {
            return false;
        }
        Backend other = (Backend) obj;
        return Objects.equals(virtualService(), other.virtualService());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Backend").add("VirtualService", virtualService()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualService":
            return Optional.ofNullable(clazz.cast(virtualService()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Backend, T> g) {
        return obj -> g.apply((Backend) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Backend> {
        /**
         * <p>
         * Specifies a virtual service to use as a backend for a virtual node.
         * </p>
         * 
         * @param virtualService
         *        Specifies a virtual service to use as a backend for a virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualService(VirtualServiceBackend virtualService);

        /**
         * <p>
         * Specifies a virtual service to use as a backend for a virtual node.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualServiceBackend.Builder} avoiding the need
         * to create one manually via {@link VirtualServiceBackend#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualServiceBackend.Builder#build()} is called immediately and
         * its result is passed to {@link #virtualService(VirtualServiceBackend)}.
         * 
         * @param virtualService
         *        a consumer that will call methods on {@link VirtualServiceBackend.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualService(VirtualServiceBackend)
         */
        default Builder virtualService(Consumer<VirtualServiceBackend.Builder> virtualService) {
            return virtualService(VirtualServiceBackend.builder().applyMutation(virtualService).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualServiceBackend virtualService;

        private BuilderImpl() {
        }

        private BuilderImpl(Backend model) {
            virtualService(model.virtualService);
        }

        public final VirtualServiceBackend.Builder getVirtualService() {
            return virtualService != null ? virtualService.toBuilder() : null;
        }

        @Override
        public final Builder virtualService(VirtualServiceBackend virtualService) {
            this.virtualService = virtualService;
            return this;
        }

        public final void setVirtualService(VirtualServiceBackend.BuilderImpl virtualService) {
            this.virtualService = virtualService != null ? virtualService.build() : null;
        }

        @Override
        public Backend build() {
            return new Backend(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
