/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual service backend for a virtual node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualServiceBackend implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualServiceBackend.Builder, VirtualServiceBackend> {
    private static final SdkField<String> VIRTUAL_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualServiceBackend::virtualServiceName)).setter(setter(Builder::virtualServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualServiceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String virtualServiceName;

    private VirtualServiceBackend(BuilderImpl builder) {
        this.virtualServiceName = builder.virtualServiceName;
    }

    /**
     * <p>
     * The name of the virtual service that is acting as a virtual node backend.
     * </p>
     * 
     * @return The name of the virtual service that is acting as a virtual node backend.
     */
    public String virtualServiceName() {
        return virtualServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualServiceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualServiceBackend)) {
            return false;
        }
        VirtualServiceBackend other = (VirtualServiceBackend) obj;
        return Objects.equals(virtualServiceName(), other.virtualServiceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualServiceBackend").add("VirtualServiceName", virtualServiceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualServiceName":
            return Optional.ofNullable(clazz.cast(virtualServiceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualServiceBackend, T> g) {
        return obj -> g.apply((VirtualServiceBackend) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualServiceBackend> {
        /**
         * <p>
         * The name of the virtual service that is acting as a virtual node backend.
         * </p>
         * 
         * @param virtualServiceName
         *        The name of the virtual service that is acting as a virtual node backend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualServiceName(String virtualServiceName);
    }

    static final class BuilderImpl implements Builder {
        private String virtualServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualServiceBackend model) {
            virtualServiceName(model.virtualServiceName);
        }

        public final String getVirtualServiceName() {
            return virtualServiceName;
        }

        @Override
        public final Builder virtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
            return this;
        }

        public final void setVirtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
        }

        @Override
        public VirtualServiceBackend build() {
            return new VirtualServiceBackend(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
