/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a service mesh returned by a describe operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MeshData implements SdkPojo, Serializable, ToCopyableBuilder<MeshData.Builder, MeshData> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(MeshData::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<ResourceMetadata> METADATA_FIELD = SdkField
            .<ResourceMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata").getter(getter(MeshData::metadata))
            .setter(setter(Builder::metadata)).constructor(ResourceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<MeshSpec> SPEC_FIELD = SdkField.<MeshSpec> builder(MarshallingType.SDK_POJO).memberName("spec")
            .getter(getter(MeshData::spec)).setter(setter(Builder::spec)).constructor(MeshSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<MeshStatus> STATUS_FIELD = SdkField.<MeshStatus> builder(MarshallingType.SDK_POJO)
            .memberName("status").getter(getter(MeshData::status)).setter(setter(Builder::status))
            .constructor(MeshStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD,
            METADATA_FIELD, SPEC_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String meshName;

    private final ResourceMetadata metadata;

    private final MeshSpec spec;

    private final MeshStatus status;

    private MeshData(BuilderImpl builder) {
        this.meshName = builder.meshName;
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the service mesh.
     * </p>
     * 
     * @return The name of the service mesh.
     */
    public final String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The associated metadata for the service mesh.
     * </p>
     * 
     * @return The associated metadata for the service mesh.
     */
    public final ResourceMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The associated specification for the service mesh.
     * </p>
     * 
     * @return The associated specification for the service mesh.
     */
    public final MeshSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The status of the service mesh.
     * </p>
     * 
     * @return The status of the service mesh.
     */
    public final MeshStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MeshData)) {
            return false;
        }
        MeshData other = (MeshData) obj;
        return Objects.equals(meshName(), other.meshName()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(spec(), other.spec()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MeshData").add("MeshName", meshName()).add("Metadata", metadata()).add("Spec", spec())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MeshData, T> g) {
        return obj -> g.apply((MeshData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MeshData> {
        /**
         * <p>
         * The name of the service mesh.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The associated metadata for the service mesh.
         * </p>
         * 
         * @param metadata
         *        The associated metadata for the service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ResourceMetadata metadata);

        /**
         * <p>
         * The associated metadata for the service mesh.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceMetadata.Builder} avoiding the
         * need to create one manually via {@link ResourceMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(ResourceMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ResourceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ResourceMetadata)
         */
        default Builder metadata(Consumer<ResourceMetadata.Builder> metadata) {
            return metadata(ResourceMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The associated specification for the service mesh.
         * </p>
         * 
         * @param spec
         *        The associated specification for the service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(MeshSpec spec);

        /**
         * <p>
         * The associated specification for the service mesh.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeshSpec.Builder} avoiding the need to
         * create one manually via {@link MeshSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeshSpec.Builder#build()} is called immediately and its result is
         * passed to {@link #spec(MeshSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link MeshSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(MeshSpec)
         */
        default Builder spec(Consumer<MeshSpec.Builder> spec) {
            return spec(MeshSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The status of the service mesh.
         * </p>
         * 
         * @param status
         *        The status of the service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(MeshStatus status);

        /**
         * <p>
         * The status of the service mesh.
         * </p>
         * This is a convenience method that creates an instance of the {@link MeshStatus.Builder} avoiding the need to
         * create one manually via {@link MeshStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MeshStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #status(MeshStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link MeshStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(MeshStatus)
         */
        default Builder status(Consumer<MeshStatus.Builder> status) {
            return status(MeshStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String meshName;

        private ResourceMetadata metadata;

        private MeshSpec spec;

        private MeshStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(MeshData model) {
            meshName(model.meshName);
            metadata(model.metadata);
            spec(model.spec);
            status(model.status);
        }

        public final String getMeshName() {
            return meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final ResourceMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ResourceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ResourceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final MeshSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        public final void setSpec(MeshSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        @Override
        public final Builder spec(MeshSpec spec) {
            this.spec = spec;
            return this;
        }

        public final MeshStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(MeshStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(MeshStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public MeshData build() {
            return new MeshData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
