/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the columns in a query execution result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnInfo implements SdkPojo, Serializable, ToCopyableBuilder<ColumnInfo.Builder, ColumnInfo> {
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogName").getter(getter(ColumnInfo::catalogName)).setter(setter(Builder::catalogName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogName").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(ColumnInfo::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(ColumnInfo::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ColumnInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(ColumnInfo::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ColumnInfo::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> PRECISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Precision").getter(getter(ColumnInfo::precision)).setter(setter(Builder::precision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Precision").build()).build();

    private static final SdkField<Integer> SCALE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Scale")
            .getter(getter(ColumnInfo::scale)).setter(setter(Builder::scale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scale").build()).build();

    private static final SdkField<String> NULLABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Nullable").getter(getter(ColumnInfo::nullableAsString)).setter(setter(Builder::nullable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nullable").build()).build();

    private static final SdkField<Boolean> CASE_SENSITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CaseSensitive").getter(getter(ColumnInfo::caseSensitive)).setter(setter(Builder::caseSensitive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseSensitive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_NAME_FIELD,
            SCHEMA_NAME_FIELD, TABLE_NAME_FIELD, NAME_FIELD, LABEL_FIELD, TYPE_FIELD, PRECISION_FIELD, SCALE_FIELD,
            NULLABLE_FIELD, CASE_SENSITIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogName;

    private final String schemaName;

    private final String tableName;

    private final String name;

    private final String label;

    private final String type;

    private final Integer precision;

    private final Integer scale;

    private final String nullable;

    private final Boolean caseSensitive;

    private ColumnInfo(BuilderImpl builder) {
        this.catalogName = builder.catalogName;
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.name = builder.name;
        this.label = builder.label;
        this.type = builder.type;
        this.precision = builder.precision;
        this.scale = builder.scale;
        this.nullable = builder.nullable;
        this.caseSensitive = builder.caseSensitive;
    }

    /**
     * <p>
     * The catalog to which the query results belong.
     * </p>
     * 
     * @return The catalog to which the query results belong.
     */
    public final String catalogName() {
        return catalogName;
    }

    /**
     * <p>
     * The schema name (database name) to which the query results belong.
     * </p>
     * 
     * @return The schema name (database name) to which the query results belong.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The table name for the query results.
     * </p>
     * 
     * @return The table name for the query results.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of the column.
     * </p>
     * 
     * @return The name of the column.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A column label.
     * </p>
     * 
     * @return A column label.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * The data type of the column.
     * </p>
     * 
     * @return The data type of the column.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38. For performance reasons, we
     * recommend up to 18 digits.
     * </p>
     * 
     * @return For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38. For performance
     *         reasons, we recommend up to 18 digits.
     */
    public final Integer precision() {
        return precision;
    }

    /**
     * <p>
     * For <code>DECIMAL</code> data types, specifies the total number of digits in the fractional part of the value.
     * Defaults to 0.
     * </p>
     * 
     * @return For <code>DECIMAL</code> data types, specifies the total number of digits in the fractional part of the
     *         value. Defaults to 0.
     */
    public final Integer scale() {
        return scale;
    }

    /**
     * <p>
     * Unsupported constraint. This value always shows as <code>UNKNOWN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullable} will
     * return {@link ColumnNullable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullableAsString}.
     * </p>
     * 
     * @return Unsupported constraint. This value always shows as <code>UNKNOWN</code>.
     * @see ColumnNullable
     */
    public final ColumnNullable nullable() {
        return ColumnNullable.fromValue(nullable);
    }

    /**
     * <p>
     * Unsupported constraint. This value always shows as <code>UNKNOWN</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullable} will
     * return {@link ColumnNullable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullableAsString}.
     * </p>
     * 
     * @return Unsupported constraint. This value always shows as <code>UNKNOWN</code>.
     * @see ColumnNullable
     */
    public final String nullableAsString() {
        return nullable;
    }

    /**
     * <p>
     * Indicates whether values in the column are case-sensitive.
     * </p>
     * 
     * @return Indicates whether values in the column are case-sensitive.
     */
    public final Boolean caseSensitive() {
        return caseSensitive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(precision());
        hashCode = 31 * hashCode + Objects.hashCode(scale());
        hashCode = 31 * hashCode + Objects.hashCode(nullableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(caseSensitive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo other = (ColumnInfo) obj;
        return Objects.equals(catalogName(), other.catalogName()) && Objects.equals(schemaName(), other.schemaName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(name(), other.name())
                && Objects.equals(label(), other.label()) && Objects.equals(type(), other.type())
                && Objects.equals(precision(), other.precision()) && Objects.equals(scale(), other.scale())
                && Objects.equals(nullableAsString(), other.nullableAsString())
                && Objects.equals(caseSensitive(), other.caseSensitive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnInfo").add("CatalogName", catalogName()).add("SchemaName", schemaName())
                .add("TableName", tableName()).add("Name", name()).add("Label", label()).add("Type", type())
                .add("Precision", precision()).add("Scale", scale()).add("Nullable", nullableAsString())
                .add("CaseSensitive", caseSensitive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogName":
            return Optional.ofNullable(clazz.cast(catalogName()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Precision":
            return Optional.ofNullable(clazz.cast(precision()));
        case "Scale":
            return Optional.ofNullable(clazz.cast(scale()));
        case "Nullable":
            return Optional.ofNullable(clazz.cast(nullableAsString()));
        case "CaseSensitive":
            return Optional.ofNullable(clazz.cast(caseSensitive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnInfo, T> g) {
        return obj -> g.apply((ColumnInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnInfo> {
        /**
         * <p>
         * The catalog to which the query results belong.
         * </p>
         * 
         * @param catalogName
         *        The catalog to which the query results belong.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogName(String catalogName);

        /**
         * <p>
         * The schema name (database name) to which the query results belong.
         * </p>
         * 
         * @param schemaName
         *        The schema name (database name) to which the query results belong.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The table name for the query results.
         * </p>
         * 
         * @param tableName
         *        The table name for the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of the column.
         * </p>
         * 
         * @param name
         *        The name of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A column label.
         * </p>
         * 
         * @param label
         *        A column label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The data type of the column.
         * </p>
         * 
         * @param type
         *        The data type of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38. For performance reasons,
         * we recommend up to 18 digits.
         * </p>
         * 
         * @param precision
         *        For <code>DECIMAL</code> data types, specifies the total number of digits, up to 38. For performance
         *        reasons, we recommend up to 18 digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder precision(Integer precision);

        /**
         * <p>
         * For <code>DECIMAL</code> data types, specifies the total number of digits in the fractional part of the
         * value. Defaults to 0.
         * </p>
         * 
         * @param scale
         *        For <code>DECIMAL</code> data types, specifies the total number of digits in the fractional part of
         *        the value. Defaults to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scale(Integer scale);

        /**
         * <p>
         * Unsupported constraint. This value always shows as <code>UNKNOWN</code>.
         * </p>
         * 
         * @param nullable
         *        Unsupported constraint. This value always shows as <code>UNKNOWN</code>.
         * @see ColumnNullable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnNullable
         */
        Builder nullable(String nullable);

        /**
         * <p>
         * Unsupported constraint. This value always shows as <code>UNKNOWN</code>.
         * </p>
         * 
         * @param nullable
         *        Unsupported constraint. This value always shows as <code>UNKNOWN</code>.
         * @see ColumnNullable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColumnNullable
         */
        Builder nullable(ColumnNullable nullable);

        /**
         * <p>
         * Indicates whether values in the column are case-sensitive.
         * </p>
         * 
         * @param caseSensitive
         *        Indicates whether values in the column are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseSensitive(Boolean caseSensitive);
    }

    static final class BuilderImpl implements Builder {
        private String catalogName;

        private String schemaName;

        private String tableName;

        private String name;

        private String label;

        private String type;

        private Integer precision;

        private Integer scale;

        private String nullable;

        private Boolean caseSensitive;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnInfo model) {
            catalogName(model.catalogName);
            schemaName(model.schemaName);
            tableName(model.tableName);
            name(model.name);
            label(model.label);
            type(model.type);
            precision(model.precision);
            scale(model.scale);
            nullable(model.nullable);
            caseSensitive(model.caseSensitive);
        }

        public final String getCatalogName() {
            return catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Integer getPrecision() {
            return precision;
        }

        public final void setPrecision(Integer precision) {
            this.precision = precision;
        }

        @Override
        public final Builder precision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public final Integer getScale() {
            return scale;
        }

        public final void setScale(Integer scale) {
            this.scale = scale;
        }

        @Override
        public final Builder scale(Integer scale) {
            this.scale = scale;
            return this;
        }

        public final String getNullable() {
            return nullable;
        }

        public final void setNullable(String nullable) {
            this.nullable = nullable;
        }

        @Override
        public final Builder nullable(String nullable) {
            this.nullable = nullable;
            return this;
        }

        @Override
        public final Builder nullable(ColumnNullable nullable) {
            this.nullable(nullable == null ? null : nullable.toString());
            return this;
        }

        public final Boolean getCaseSensitive() {
            return caseSensitive;
        }

        public final void setCaseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        public final Builder caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public ColumnInfo build() {
            return new ColumnInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
