/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNotebookRequest extends AthenaRequest implements
        ToCopyableBuilder<CreateNotebookRequest.Builder, CreateNotebookRequest> {
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(CreateNotebookRequest::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateNotebookRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken").getter(getter(CreateNotebookRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUP_FIELD, NAME_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD));

    private final String workGroup;

    private final String name;

    private final String clientRequestToken;

    private CreateNotebookRequest(BuilderImpl builder) {
        super(builder);
        this.workGroup = builder.workGroup;
        this.name = builder.name;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The name of the Spark enabled workgroup in which the notebook will be created.
     * </p>
     * 
     * @return The name of the Spark enabled workgroup in which the notebook will be created.
     */
    public final String workGroup() {
        return workGroup;
    }

    /**
     * <p>
     * The name of the <code>ipynb</code> file to be created in the Spark workgroup, without the <code>.ipynb</code>
     * extension.
     * </p>
     * 
     * @return The name of the <code>ipynb</code> file to be created in the Spark workgroup, without the
     *         <code>.ipynb</code> extension.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique case-sensitive string used to ensure the request to create the notebook is idempotent (executes only
     * once).
     * </p>
     * <important>
     * <p>
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK
     * for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web
     * Services CLI, you must provide this token or the action will fail.
     * </p>
     * </important>
     * 
     * @return A unique case-sensitive string used to ensure the request to create the notebook is idempotent (executes
     *         only once).</p> <important>
     *         <p>
     *         This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web
     *         Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK
     *         or the Amazon Web Services CLI, you must provide this token or the action will fail.
     *         </p>
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotebookRequest)) {
            return false;
        }
        CreateNotebookRequest other = (CreateNotebookRequest) obj;
        return Objects.equals(workGroup(), other.workGroup()) && Objects.equals(name(), other.name())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNotebookRequest").add("WorkGroup", workGroup()).add("Name", name())
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNotebookRequest, T> g) {
        return obj -> g.apply((CreateNotebookRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNotebookRequest> {
        /**
         * <p>
         * The name of the Spark enabled workgroup in which the notebook will be created.
         * </p>
         * 
         * @param workGroup
         *        The name of the Spark enabled workgroup in which the notebook will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        /**
         * <p>
         * The name of the <code>ipynb</code> file to be created in the Spark workgroup, without the <code>.ipynb</code>
         * extension.
         * </p>
         * 
         * @param name
         *        The name of the <code>ipynb</code> file to be created in the Spark workgroup, without the
         *        <code>.ipynb</code> extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique case-sensitive string used to ensure the request to create the notebook is idempotent (executes only
         * once).
         * </p>
         * <important>
         * <p>
         * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services
         * SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon
         * Web Services CLI, you must provide this token or the action will fail.
         * </p>
         * </important>
         * 
         * @param clientRequestToken
         *        A unique case-sensitive string used to ensure the request to create the notebook is idempotent
         *        (executes only once).</p> <important>
         *        <p>
         *        This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web
         *        Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services
         *        SDK or the Amazon Web Services CLI, you must provide this token or the action will fail.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String workGroup;

        private String name;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotebookRequest model) {
            super(model);
            workGroup(model.workGroup);
            name(model.name);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotebookRequest build() {
            return new CreateNotebookRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
