/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePresignedNotebookUrlResponse extends AthenaResponse implements
        ToCopyableBuilder<CreatePresignedNotebookUrlResponse.Builder, CreatePresignedNotebookUrlResponse> {
    private static final SdkField<String> NOTEBOOK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookUrl").getter(getter(CreatePresignedNotebookUrlResponse::notebookUrl))
            .setter(setter(Builder::notebookUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookUrl").build()).build();

    private static final SdkField<String> AUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthToken").getter(getter(CreatePresignedNotebookUrlResponse::authToken))
            .setter(setter(Builder::authToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthToken").build()).build();

    private static final SdkField<Long> AUTH_TOKEN_EXPIRATION_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("AuthTokenExpirationTime").getter(getter(CreatePresignedNotebookUrlResponse::authTokenExpirationTime))
            .setter(setter(Builder::authTokenExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenExpirationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_URL_FIELD,
            AUTH_TOKEN_FIELD, AUTH_TOKEN_EXPIRATION_TIME_FIELD));

    private final String notebookUrl;

    private final String authToken;

    private final Long authTokenExpirationTime;

    private CreatePresignedNotebookUrlResponse(BuilderImpl builder) {
        super(builder);
        this.notebookUrl = builder.notebookUrl;
        this.authToken = builder.authToken;
        this.authTokenExpirationTime = builder.authTokenExpirationTime;
    }

    /**
     * <p>
     * The URL of the notebook. The URL includes the authentication token and notebook file name and points directly to
     * the opened notebook.
     * </p>
     * 
     * @return The URL of the notebook. The URL includes the authentication token and notebook file name and points
     *         directly to the opened notebook.
     */
    public final String notebookUrl() {
        return notebookUrl;
    }

    /**
     * <p>
     * The authentication token for the notebook.
     * </p>
     * 
     * @return The authentication token for the notebook.
     */
    public final String authToken() {
        return authToken;
    }

    /**
     * <p>
     * The UTC epoch time when the authentication token expires.
     * </p>
     * 
     * @return The UTC epoch time when the authentication token expires.
     */
    public final Long authTokenExpirationTime() {
        return authTokenExpirationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookUrl());
        hashCode = 31 * hashCode + Objects.hashCode(authToken());
        hashCode = 31 * hashCode + Objects.hashCode(authTokenExpirationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedNotebookUrlResponse)) {
            return false;
        }
        CreatePresignedNotebookUrlResponse other = (CreatePresignedNotebookUrlResponse) obj;
        return Objects.equals(notebookUrl(), other.notebookUrl()) && Objects.equals(authToken(), other.authToken())
                && Objects.equals(authTokenExpirationTime(), other.authTokenExpirationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePresignedNotebookUrlResponse").add("NotebookUrl", notebookUrl())
                .add("AuthToken", authToken()).add("AuthTokenExpirationTime", authTokenExpirationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookUrl":
            return Optional.ofNullable(clazz.cast(notebookUrl()));
        case "AuthToken":
            return Optional.ofNullable(clazz.cast(authToken()));
        case "AuthTokenExpirationTime":
            return Optional.ofNullable(clazz.cast(authTokenExpirationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedNotebookUrlResponse, T> g) {
        return obj -> g.apply((CreatePresignedNotebookUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePresignedNotebookUrlResponse> {
        /**
         * <p>
         * The URL of the notebook. The URL includes the authentication token and notebook file name and points directly
         * to the opened notebook.
         * </p>
         * 
         * @param notebookUrl
         *        The URL of the notebook. The URL includes the authentication token and notebook file name and points
         *        directly to the opened notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookUrl(String notebookUrl);

        /**
         * <p>
         * The authentication token for the notebook.
         * </p>
         * 
         * @param authToken
         *        The authentication token for the notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authToken(String authToken);

        /**
         * <p>
         * The UTC epoch time when the authentication token expires.
         * </p>
         * 
         * @param authTokenExpirationTime
         *        The UTC epoch time when the authentication token expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTokenExpirationTime(Long authTokenExpirationTime);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String notebookUrl;

        private String authToken;

        private Long authTokenExpirationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedNotebookUrlResponse model) {
            super(model);
            notebookUrl(model.notebookUrl);
            authToken(model.authToken);
            authTokenExpirationTime(model.authTokenExpirationTime);
        }

        public final String getNotebookUrl() {
            return notebookUrl;
        }

        public final void setNotebookUrl(String notebookUrl) {
            this.notebookUrl = notebookUrl;
        }

        @Override
        public final Builder notebookUrl(String notebookUrl) {
            this.notebookUrl = notebookUrl;
            return this;
        }

        public final String getAuthToken() {
            return authToken;
        }

        public final void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        @Override
        public final Builder authToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public final Long getAuthTokenExpirationTime() {
            return authTokenExpirationTime;
        }

        public final void setAuthTokenExpirationTime(Long authTokenExpirationTime) {
            this.authTokenExpirationTime = authTokenExpirationTime;
        }

        @Override
        public final Builder authTokenExpirationTime(Long authTokenExpirationTime) {
            this.authTokenExpirationTime = authTokenExpirationTime;
            return this;
        }

        @Override
        public CreatePresignedNotebookUrlResponse build() {
            return new CreatePresignedNotebookUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
