/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Timeline statistics such as query queue time, planning time, execution time, service processing time, and total
 * execution time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryRuntimeStatisticsTimeline implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryRuntimeStatisticsTimeline.Builder, QueryRuntimeStatisticsTimeline> {
    private static final SdkField<Long> QUERY_QUEUE_TIME_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueryQueueTimeInMillis").getter(getter(QueryRuntimeStatisticsTimeline::queryQueueTimeInMillis))
            .setter(setter(Builder::queryQueueTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryQueueTimeInMillis").build())
            .build();

    private static final SdkField<Long> SERVICE_PRE_PROCESSING_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ServicePreProcessingTimeInMillis")
            .getter(getter(QueryRuntimeStatisticsTimeline::servicePreProcessingTimeInMillis))
            .setter(setter(Builder::servicePreProcessingTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePreProcessingTimeInMillis")
                    .build()).build();

    private static final SdkField<Long> QUERY_PLANNING_TIME_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueryPlanningTimeInMillis").getter(getter(QueryRuntimeStatisticsTimeline::queryPlanningTimeInMillis))
            .setter(setter(Builder::queryPlanningTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPlanningTimeInMillis").build())
            .build();

    private static final SdkField<Long> ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EngineExecutionTimeInMillis")
            .getter(getter(QueryRuntimeStatisticsTimeline::engineExecutionTimeInMillis))
            .setter(setter(Builder::engineExecutionTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineExecutionTimeInMillis")
                    .build()).build();

    private static final SdkField<Long> SERVICE_PROCESSING_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ServiceProcessingTimeInMillis")
            .getter(getter(QueryRuntimeStatisticsTimeline::serviceProcessingTimeInMillis))
            .setter(setter(Builder::serviceProcessingTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProcessingTimeInMillis")
                    .build()).build();

    private static final SdkField<Long> TOTAL_EXECUTION_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalExecutionTimeInMillis")
            .getter(getter(QueryRuntimeStatisticsTimeline::totalExecutionTimeInMillis))
            .setter(setter(Builder::totalExecutionTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalExecutionTimeInMillis").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(QUERY_QUEUE_TIME_IN_MILLIS_FIELD, SERVICE_PRE_PROCESSING_TIME_IN_MILLIS_FIELD,
                    QUERY_PLANNING_TIME_IN_MILLIS_FIELD, ENGINE_EXECUTION_TIME_IN_MILLIS_FIELD,
                    SERVICE_PROCESSING_TIME_IN_MILLIS_FIELD, TOTAL_EXECUTION_TIME_IN_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long queryQueueTimeInMillis;

    private final Long servicePreProcessingTimeInMillis;

    private final Long queryPlanningTimeInMillis;

    private final Long engineExecutionTimeInMillis;

    private final Long serviceProcessingTimeInMillis;

    private final Long totalExecutionTimeInMillis;

    private QueryRuntimeStatisticsTimeline(BuilderImpl builder) {
        this.queryQueueTimeInMillis = builder.queryQueueTimeInMillis;
        this.servicePreProcessingTimeInMillis = builder.servicePreProcessingTimeInMillis;
        this.queryPlanningTimeInMillis = builder.queryPlanningTimeInMillis;
        this.engineExecutionTimeInMillis = builder.engineExecutionTimeInMillis;
        this.serviceProcessingTimeInMillis = builder.serviceProcessingTimeInMillis;
        this.totalExecutionTimeInMillis = builder.totalExecutionTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that the query was in your query queue waiting for resources. Note that if transient
     * errors occur, Athena might automatically add the query back to the queue.
     * </p>
     * 
     * @return The number of milliseconds that the query was in your query queue waiting for resources. Note that if
     *         transient errors occur, Athena might automatically add the query back to the queue.
     */
    public final Long queryQueueTimeInMillis() {
        return queryQueueTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that Athena spends on preprocessing before it submits the query to the engine.
     * </p>
     * 
     * @return The number of milliseconds that Athena spends on preprocessing before it submits the query to the engine.
     */
    public final Long servicePreProcessingTimeInMillis() {
        return servicePreProcessingTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent
     * retrieving table partitions from the data source. Note that because the query engine performs the query planning,
     * query planning time is a subset of engine processing time.
     * </p>
     * 
     * @return The number of milliseconds that Athena took to plan the query processing flow. This includes the time
     *         spent retrieving table partitions from the data source. Note that because the query engine performs the
     *         query planning, query planning time is a subset of engine processing time.
     */
    public final Long queryPlanningTimeInMillis() {
        return queryPlanningTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that the query took to execute.
     * </p>
     * 
     * @return The number of milliseconds that the query took to execute.
     */
    public final Long engineExecutionTimeInMillis() {
        return engineExecutionTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that Athena took to finalize and publish the query results after the query engine
     * finished running the query.
     * </p>
     * 
     * @return The number of milliseconds that Athena took to finalize and publish the query results after the query
     *         engine finished running the query.
     */
    public final Long serviceProcessingTimeInMillis() {
        return serviceProcessingTimeInMillis;
    }

    /**
     * <p>
     * The number of milliseconds that Athena took to run the query.
     * </p>
     * 
     * @return The number of milliseconds that Athena took to run the query.
     */
    public final Long totalExecutionTimeInMillis() {
        return totalExecutionTimeInMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryQueueTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(servicePreProcessingTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(queryPlanningTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(engineExecutionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(serviceProcessingTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(totalExecutionTimeInMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRuntimeStatisticsTimeline)) {
            return false;
        }
        QueryRuntimeStatisticsTimeline other = (QueryRuntimeStatisticsTimeline) obj;
        return Objects.equals(queryQueueTimeInMillis(), other.queryQueueTimeInMillis())
                && Objects.equals(servicePreProcessingTimeInMillis(), other.servicePreProcessingTimeInMillis())
                && Objects.equals(queryPlanningTimeInMillis(), other.queryPlanningTimeInMillis())
                && Objects.equals(engineExecutionTimeInMillis(), other.engineExecutionTimeInMillis())
                && Objects.equals(serviceProcessingTimeInMillis(), other.serviceProcessingTimeInMillis())
                && Objects.equals(totalExecutionTimeInMillis(), other.totalExecutionTimeInMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryRuntimeStatisticsTimeline").add("QueryQueueTimeInMillis", queryQueueTimeInMillis())
                .add("ServicePreProcessingTimeInMillis", servicePreProcessingTimeInMillis())
                .add("QueryPlanningTimeInMillis", queryPlanningTimeInMillis())
                .add("EngineExecutionTimeInMillis", engineExecutionTimeInMillis())
                .add("ServiceProcessingTimeInMillis", serviceProcessingTimeInMillis())
                .add("TotalExecutionTimeInMillis", totalExecutionTimeInMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryQueueTimeInMillis":
            return Optional.ofNullable(clazz.cast(queryQueueTimeInMillis()));
        case "ServicePreProcessingTimeInMillis":
            return Optional.ofNullable(clazz.cast(servicePreProcessingTimeInMillis()));
        case "QueryPlanningTimeInMillis":
            return Optional.ofNullable(clazz.cast(queryPlanningTimeInMillis()));
        case "EngineExecutionTimeInMillis":
            return Optional.ofNullable(clazz.cast(engineExecutionTimeInMillis()));
        case "ServiceProcessingTimeInMillis":
            return Optional.ofNullable(clazz.cast(serviceProcessingTimeInMillis()));
        case "TotalExecutionTimeInMillis":
            return Optional.ofNullable(clazz.cast(totalExecutionTimeInMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRuntimeStatisticsTimeline, T> g) {
        return obj -> g.apply((QueryRuntimeStatisticsTimeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryRuntimeStatisticsTimeline> {
        /**
         * <p>
         * The number of milliseconds that the query was in your query queue waiting for resources. Note that if
         * transient errors occur, Athena might automatically add the query back to the queue.
         * </p>
         * 
         * @param queryQueueTimeInMillis
         *        The number of milliseconds that the query was in your query queue waiting for resources. Note that if
         *        transient errors occur, Athena might automatically add the query back to the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryQueueTimeInMillis(Long queryQueueTimeInMillis);

        /**
         * <p>
         * The number of milliseconds that Athena spends on preprocessing before it submits the query to the engine.
         * </p>
         * 
         * @param servicePreProcessingTimeInMillis
         *        The number of milliseconds that Athena spends on preprocessing before it submits the query to the
         *        engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePreProcessingTimeInMillis(Long servicePreProcessingTimeInMillis);

        /**
         * <p>
         * The number of milliseconds that Athena took to plan the query processing flow. This includes the time spent
         * retrieving table partitions from the data source. Note that because the query engine performs the query
         * planning, query planning time is a subset of engine processing time.
         * </p>
         * 
         * @param queryPlanningTimeInMillis
         *        The number of milliseconds that Athena took to plan the query processing flow. This includes the time
         *        spent retrieving table partitions from the data source. Note that because the query engine performs
         *        the query planning, query planning time is a subset of engine processing time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryPlanningTimeInMillis(Long queryPlanningTimeInMillis);

        /**
         * <p>
         * The number of milliseconds that the query took to execute.
         * </p>
         * 
         * @param engineExecutionTimeInMillis
         *        The number of milliseconds that the query took to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis);

        /**
         * <p>
         * The number of milliseconds that Athena took to finalize and publish the query results after the query engine
         * finished running the query.
         * </p>
         * 
         * @param serviceProcessingTimeInMillis
         *        The number of milliseconds that Athena took to finalize and publish the query results after the query
         *        engine finished running the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceProcessingTimeInMillis(Long serviceProcessingTimeInMillis);

        /**
         * <p>
         * The number of milliseconds that Athena took to run the query.
         * </p>
         * 
         * @param totalExecutionTimeInMillis
         *        The number of milliseconds that Athena took to run the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalExecutionTimeInMillis(Long totalExecutionTimeInMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long queryQueueTimeInMillis;

        private Long servicePreProcessingTimeInMillis;

        private Long queryPlanningTimeInMillis;

        private Long engineExecutionTimeInMillis;

        private Long serviceProcessingTimeInMillis;

        private Long totalExecutionTimeInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRuntimeStatisticsTimeline model) {
            queryQueueTimeInMillis(model.queryQueueTimeInMillis);
            servicePreProcessingTimeInMillis(model.servicePreProcessingTimeInMillis);
            queryPlanningTimeInMillis(model.queryPlanningTimeInMillis);
            engineExecutionTimeInMillis(model.engineExecutionTimeInMillis);
            serviceProcessingTimeInMillis(model.serviceProcessingTimeInMillis);
            totalExecutionTimeInMillis(model.totalExecutionTimeInMillis);
        }

        public final Long getQueryQueueTimeInMillis() {
            return queryQueueTimeInMillis;
        }

        public final void setQueryQueueTimeInMillis(Long queryQueueTimeInMillis) {
            this.queryQueueTimeInMillis = queryQueueTimeInMillis;
        }

        @Override
        public final Builder queryQueueTimeInMillis(Long queryQueueTimeInMillis) {
            this.queryQueueTimeInMillis = queryQueueTimeInMillis;
            return this;
        }

        public final Long getServicePreProcessingTimeInMillis() {
            return servicePreProcessingTimeInMillis;
        }

        public final void setServicePreProcessingTimeInMillis(Long servicePreProcessingTimeInMillis) {
            this.servicePreProcessingTimeInMillis = servicePreProcessingTimeInMillis;
        }

        @Override
        public final Builder servicePreProcessingTimeInMillis(Long servicePreProcessingTimeInMillis) {
            this.servicePreProcessingTimeInMillis = servicePreProcessingTimeInMillis;
            return this;
        }

        public final Long getQueryPlanningTimeInMillis() {
            return queryPlanningTimeInMillis;
        }

        public final void setQueryPlanningTimeInMillis(Long queryPlanningTimeInMillis) {
            this.queryPlanningTimeInMillis = queryPlanningTimeInMillis;
        }

        @Override
        public final Builder queryPlanningTimeInMillis(Long queryPlanningTimeInMillis) {
            this.queryPlanningTimeInMillis = queryPlanningTimeInMillis;
            return this;
        }

        public final Long getEngineExecutionTimeInMillis() {
            return engineExecutionTimeInMillis;
        }

        public final void setEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
        }

        @Override
        public final Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
            return this;
        }

        public final Long getServiceProcessingTimeInMillis() {
            return serviceProcessingTimeInMillis;
        }

        public final void setServiceProcessingTimeInMillis(Long serviceProcessingTimeInMillis) {
            this.serviceProcessingTimeInMillis = serviceProcessingTimeInMillis;
        }

        @Override
        public final Builder serviceProcessingTimeInMillis(Long serviceProcessingTimeInMillis) {
            this.serviceProcessingTimeInMillis = serviceProcessingTimeInMillis;
            return this;
        }

        public final Long getTotalExecutionTimeInMillis() {
            return totalExecutionTimeInMillis;
        }

        public final void setTotalExecutionTimeInMillis(Long totalExecutionTimeInMillis) {
            this.totalExecutionTimeInMillis = totalExecutionTimeInMillis;
        }

        @Override
        public final Builder totalExecutionTimeInMillis(Long totalExecutionTimeInMillis) {
            this.totalExecutionTimeInMillis = totalExecutionTimeInMillis;
            return this;
        }

        @Override
        public QueryRuntimeStatisticsTimeline build() {
            return new QueryRuntimeStatisticsTimeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
