/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.Database;
import software.amazon.awssdk.services.athena.model.ListDatabasesRequest;
import software.amazon.awssdk.services.athena.model.ListDatabasesResponse;

public class ListDatabasesPublisher
implements SdkPublisher<ListDatabasesResponse> {
    private final AthenaAsyncClient client;
    private final ListDatabasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDatabasesPublisher(AthenaAsyncClient client, ListDatabasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDatabasesPublisher(AthenaAsyncClient client, ListDatabasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDatabasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDatabasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Database> databaseList() {
        Function<ListDatabasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.databaseList() != null) {
                return response.databaseList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDatabasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDatabasesResponseFetcher
    implements AsyncPageFetcher<ListDatabasesResponse> {
        private ListDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(ListDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDatabasesResponse> nextPage(ListDatabasesResponse previousPage) {
            if (previousPage == null) {
                return ListDatabasesPublisher.this.client.listDatabases(ListDatabasesPublisher.this.firstRequest);
            }
            return ListDatabasesPublisher.this.client.listDatabases((ListDatabasesRequest)((Object)ListDatabasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

