/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerRequest;
import software.amazon.awssdk.services.auditmanager.model.ControlType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListControlsRequest
extends AuditManagerRequest
implements ToCopyableBuilder<Builder, ListControlsRequest> {
    private static final SdkField<String> CONTROL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlType").getter(ListControlsRequest.getter(ListControlsRequest::controlTypeAsString)).setter(ListControlsRequest.setter(Builder::controlType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("controlType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListControlsRequest.getter(ListControlsRequest::nextToken)).setter(ListControlsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListControlsRequest.getter(ListControlsRequest::maxResults)).setter(ListControlsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> CONTROL_CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlCatalogId").getter(ListControlsRequest.getter(ListControlsRequest::controlCatalogId)).setter(ListControlsRequest.setter(Builder::controlCatalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("controlCatalogId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONTROL_CATALOG_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListControlsRequest.memberNameToFieldInitializer();
    private final String controlType;
    private final String nextToken;
    private final Integer maxResults;
    private final String controlCatalogId;

    private ListControlsRequest(BuilderImpl builder) {
        super(builder);
        this.controlType = builder.controlType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.controlCatalogId = builder.controlCatalogId;
    }

    public final ControlType controlType() {
        return ControlType.fromValue(this.controlType);
    }

    public final String controlTypeAsString() {
        return this.controlType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String controlCatalogId() {
        return this.controlCatalogId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.controlTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlCatalogId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlsRequest)) {
            return false;
        }
        ListControlsRequest other = (ListControlsRequest)((Object)obj);
        return Objects.equals(this.controlTypeAsString(), other.controlTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.controlCatalogId(), other.controlCatalogId());
    }

    public final String toString() {
        return ToString.builder((String)"ListControlsRequest").add("ControlType", (Object)this.controlTypeAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ControlCatalogId", (Object)this.controlCatalogId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "controlType": {
                return Optional.ofNullable(clazz.cast(this.controlTypeAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "controlCatalogId": {
                return Optional.ofNullable(clazz.cast(this.controlCatalogId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("controlType", CONTROL_TYPE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("controlCatalogId", CONTROL_CATALOG_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListControlsRequest, T> g) {
        return obj -> g.apply((ListControlsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerRequest.BuilderImpl
    implements Builder {
        private String controlType;
        private String nextToken;
        private Integer maxResults;
        private String controlCatalogId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlsRequest model) {
            super(model);
            this.controlType(model.controlType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.controlCatalogId(model.controlCatalogId);
        }

        public final String getControlType() {
            return this.controlType;
        }

        public final void setControlType(String controlType) {
            this.controlType = controlType;
        }

        @Override
        public final Builder controlType(String controlType) {
            this.controlType = controlType;
            return this;
        }

        @Override
        public final Builder controlType(ControlType controlType) {
            this.controlType(controlType == null ? null : controlType.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getControlCatalogId() {
            return this.controlCatalogId;
        }

        public final void setControlCatalogId(String controlCatalogId) {
            this.controlCatalogId = controlCatalogId;
        }

        @Override
        public final Builder controlCatalogId(String controlCatalogId) {
            this.controlCatalogId = controlCatalogId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListControlsRequest build() {
            return new ListControlsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AuditManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListControlsRequest> {
        public Builder controlType(String var1);

        public Builder controlType(ControlType var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder controlCatalogId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

