/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class X12FunctionalGroupHeaders
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, X12FunctionalGroupHeaders> {
    private static final SdkField<String> APPLICATION_SENDER_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationSenderCode").getter(X12FunctionalGroupHeaders.getter(X12FunctionalGroupHeaders::applicationSenderCode)).setter(X12FunctionalGroupHeaders.setter(Builder::applicationSenderCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationSenderCode").build()}).build();
    private static final SdkField<String> APPLICATION_RECEIVER_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationReceiverCode").getter(X12FunctionalGroupHeaders.getter(X12FunctionalGroupHeaders::applicationReceiverCode)).setter(X12FunctionalGroupHeaders.setter(Builder::applicationReceiverCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationReceiverCode").build()}).build();
    private static final SdkField<String> RESPONSIBLE_AGENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responsibleAgencyCode").getter(X12FunctionalGroupHeaders.getter(X12FunctionalGroupHeaders::responsibleAgencyCode)).setter(X12FunctionalGroupHeaders.setter(Builder::responsibleAgencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responsibleAgencyCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SENDER_CODE_FIELD, APPLICATION_RECEIVER_CODE_FIELD, RESPONSIBLE_AGENCY_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = X12FunctionalGroupHeaders.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationSenderCode;
    private final String applicationReceiverCode;
    private final String responsibleAgencyCode;

    private X12FunctionalGroupHeaders(BuilderImpl builder) {
        this.applicationSenderCode = builder.applicationSenderCode;
        this.applicationReceiverCode = builder.applicationReceiverCode;
        this.responsibleAgencyCode = builder.responsibleAgencyCode;
    }

    public final String applicationSenderCode() {
        return this.applicationSenderCode;
    }

    public final String applicationReceiverCode() {
        return this.applicationReceiverCode;
    }

    public final String responsibleAgencyCode() {
        return this.responsibleAgencyCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSenderCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationReceiverCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.responsibleAgencyCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof X12FunctionalGroupHeaders)) {
            return false;
        }
        X12FunctionalGroupHeaders other = (X12FunctionalGroupHeaders)obj;
        return Objects.equals(this.applicationSenderCode(), other.applicationSenderCode()) && Objects.equals(this.applicationReceiverCode(), other.applicationReceiverCode()) && Objects.equals(this.responsibleAgencyCode(), other.responsibleAgencyCode());
    }

    public final String toString() {
        return ToString.builder((String)"X12FunctionalGroupHeaders").add("ApplicationSenderCode", (Object)this.applicationSenderCode()).add("ApplicationReceiverCode", (Object)this.applicationReceiverCode()).add("ResponsibleAgencyCode", (Object)this.responsibleAgencyCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationSenderCode": {
                return Optional.ofNullable(clazz.cast(this.applicationSenderCode()));
            }
            case "applicationReceiverCode": {
                return Optional.ofNullable(clazz.cast(this.applicationReceiverCode()));
            }
            case "responsibleAgencyCode": {
                return Optional.ofNullable(clazz.cast(this.responsibleAgencyCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("applicationSenderCode", APPLICATION_SENDER_CODE_FIELD);
        map.put("applicationReceiverCode", APPLICATION_RECEIVER_CODE_FIELD);
        map.put("responsibleAgencyCode", RESPONSIBLE_AGENCY_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<X12FunctionalGroupHeaders, T> g) {
        return obj -> g.apply((X12FunctionalGroupHeaders)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationSenderCode;
        private String applicationReceiverCode;
        private String responsibleAgencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(X12FunctionalGroupHeaders model) {
            this.applicationSenderCode(model.applicationSenderCode);
            this.applicationReceiverCode(model.applicationReceiverCode);
            this.responsibleAgencyCode(model.responsibleAgencyCode);
        }

        public final String getApplicationSenderCode() {
            return this.applicationSenderCode;
        }

        public final void setApplicationSenderCode(String applicationSenderCode) {
            this.applicationSenderCode = applicationSenderCode;
        }

        @Override
        public final Builder applicationSenderCode(String applicationSenderCode) {
            this.applicationSenderCode = applicationSenderCode;
            return this;
        }

        public final String getApplicationReceiverCode() {
            return this.applicationReceiverCode;
        }

        public final void setApplicationReceiverCode(String applicationReceiverCode) {
            this.applicationReceiverCode = applicationReceiverCode;
        }

        @Override
        public final Builder applicationReceiverCode(String applicationReceiverCode) {
            this.applicationReceiverCode = applicationReceiverCode;
            return this;
        }

        public final String getResponsibleAgencyCode() {
            return this.responsibleAgencyCode;
        }

        public final void setResponsibleAgencyCode(String responsibleAgencyCode) {
            this.responsibleAgencyCode = responsibleAgencyCode;
        }

        @Override
        public final Builder responsibleAgencyCode(String responsibleAgencyCode) {
            this.responsibleAgencyCode = responsibleAgencyCode;
            return this;
        }

        public X12FunctionalGroupHeaders build() {
            return new X12FunctionalGroupHeaders(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, X12FunctionalGroupHeaders> {
        public Builder applicationSenderCode(String var1);

        public Builder applicationReceiverCode(String var1);

        public Builder responsibleAgencyCode(String var1);
    }
}

