/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.b2bi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.b2bi.B2BiAsyncClient;
import software.amazon.awssdk.services.b2bi.internal.UserAgentUtils;
import software.amazon.awssdk.services.b2bi.model.ListTransformersRequest;
import software.amazon.awssdk.services.b2bi.model.ListTransformersResponse;
import software.amazon.awssdk.services.b2bi.model.TransformerSummary;

public class ListTransformersPublisher
implements SdkPublisher<ListTransformersResponse> {
    private final B2BiAsyncClient client;
    private final ListTransformersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTransformersPublisher(B2BiAsyncClient client, ListTransformersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTransformersPublisher(B2BiAsyncClient client, ListTransformersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTransformersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTransformersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransformerSummary> transformers() {
        Function<ListTransformersResponse, Iterator> getIterator = response -> {
            if (response != null && response.transformers() != null) {
                return response.transformers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTransformersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTransformersResponseFetcher
    implements AsyncPageFetcher<ListTransformersResponse> {
        private ListTransformersResponseFetcher() {
        }

        public boolean hasNextPage(ListTransformersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTransformersResponse> nextPage(ListTransformersResponse previousPage) {
            if (previousPage == null) {
                return ListTransformersPublisher.this.client.listTransformers(ListTransformersPublisher.this.firstRequest);
            }
            return ListTransformersPublisher.this.client.listTransformers((ListTransformersRequest)((Object)ListTransformersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

