/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a task definition that describes the container and volume definitions of an Amazon ECS task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsTaskDetails implements SdkPojo, Serializable, ToCopyableBuilder<EcsTaskDetails.Builder, EcsTaskDetails> {
    private static final SdkField<List<TaskContainerDetails>> CONTAINERS_FIELD = SdkField
            .<List<TaskContainerDetails>> builder(MarshallingType.LIST)
            .memberName("containers")
            .getter(getter(EcsTaskDetails::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskContainerDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskContainerDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTAINER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerInstanceArn").getter(getter(EcsTaskDetails::containerInstanceArn))
            .setter(setter(Builder::containerInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArn").build())
            .build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskArn").getter(getter(EcsTaskDetails::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()).build();

    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField
            .<EphemeralStorage> builder(MarshallingType.SDK_POJO).memberName("ephemeralStorage")
            .getter(getter(EcsTaskDetails::ephemeralStorage)).setter(setter(Builder::ephemeralStorage))
            .constructor(EphemeralStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeralStorage").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(EcsTaskDetails::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platformVersion").getter(getter(EcsTaskDetails::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<String> IPC_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipcMode").getter(getter(EcsTaskDetails::ipcMode)).setter(setter(Builder::ipcMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipcMode").build()).build();

    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRoleArn").getter(getter(EcsTaskDetails::taskRoleArn)).setter(setter(Builder::taskRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()).build();

    private static final SdkField<String> PID_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pidMode").getter(getter(EcsTaskDetails::pidMode)).setter(setter(Builder::pidMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pidMode").build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(EcsTaskDetails::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<RuntimePlatform> RUNTIME_PLATFORM_FIELD = SdkField
            .<RuntimePlatform> builder(MarshallingType.SDK_POJO).memberName("runtimePlatform")
            .getter(getter(EcsTaskDetails::runtimePlatform)).setter(setter(Builder::runtimePlatform))
            .constructor(RuntimePlatform::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimePlatform").build()).build();

    private static final SdkField<List<Volume>> VOLUMES_FIELD = SdkField
            .<List<Volume>> builder(MarshallingType.LIST)
            .memberName("volumes")
            .getter(getter(EcsTaskDetails::volumes))
            .setter(setter(Builder::volumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Volume> builder(MarshallingType.SDK_POJO)
                                            .constructor(Volume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD,
            CONTAINER_INSTANCE_ARN_FIELD, TASK_ARN_FIELD, EPHEMERAL_STORAGE_FIELD, EXECUTION_ROLE_ARN_FIELD,
            PLATFORM_VERSION_FIELD, IPC_MODE_FIELD, TASK_ROLE_ARN_FIELD, PID_MODE_FIELD, NETWORK_CONFIGURATION_FIELD,
            RUNTIME_PLATFORM_FIELD, VOLUMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TaskContainerDetails> containers;

    private final String containerInstanceArn;

    private final String taskArn;

    private final EphemeralStorage ephemeralStorage;

    private final String executionRoleArn;

    private final String platformVersion;

    private final String ipcMode;

    private final String taskRoleArn;

    private final String pidMode;

    private final NetworkConfiguration networkConfiguration;

    private final RuntimePlatform runtimePlatform;

    private final List<Volume> volumes;

    private EcsTaskDetails(BuilderImpl builder) {
        this.containers = builder.containers;
        this.containerInstanceArn = builder.containerInstanceArn;
        this.taskArn = builder.taskArn;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.executionRoleArn = builder.executionRoleArn;
        this.platformVersion = builder.platformVersion;
        this.ipcMode = builder.ipcMode;
        this.taskRoleArn = builder.taskRoleArn;
        this.pidMode = builder.pidMode;
        this.networkConfiguration = builder.networkConfiguration;
        this.runtimePlatform = builder.runtimePlatform;
        this.volumes = builder.volumes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of containers that are included in the <code>taskProperties</code> list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return A list of containers that are included in the <code>taskProperties</code> list.
     */
    public final List<TaskContainerDetails> containers() {
        return containers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the container instance that hosts the task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the container instance that hosts the task.
     */
    public final String containerInstanceArn() {
        return containerInstanceArn;
    }

    /**
     * <p>
     * The ARN of the Amazon ECS task.
     * </p>
     * 
     * @return The ARN of the Amazon ECS task.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The amount of ephemeral storage allocated for the task.
     * </p>
     * 
     * @return The amount of ephemeral storage allocated for the task.
     */
    public final EphemeralStorage ephemeralStorage() {
        return ephemeralStorage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution role that Batch can assume. For more information, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">Batch execution IAM role</a> in
     * the <i>Batch User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution role that Batch can assume. For more information, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">Batch execution IAM
     *         role</a> in the <i>Batch User Guide</i>.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The Fargate platform version where the jobs are running.
     * </p>
     * 
     * @return The Fargate platform version where the jobs are running.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The IPC resource namespace to use for the containers in the task.
     * </p>
     * 
     * @return The IPC resource namespace to use for the containers in the task.
     */
    public final String ipcMode() {
        return ipcMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that the container can assume for Amazon Web Services permissions.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM roles for tasks</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * This is object is comparable to <a
     * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html"
     * >ContainerProperties:jobRoleArn</a>.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that the container can assume for Amazon Web Services
     *         permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM roles for
     *         tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> <note>
     *         <p>
     *         This is object is comparable to <a
     *         href="https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html"
     *         >ContainerProperties:jobRoleArn</a>.
     *         </p>
     */
    public final String taskRoleArn() {
        return taskRoleArn;
    }

    /**
     * <p>
     * The process namespace to use for the containers in the task.
     * </p>
     * 
     * @return The process namespace to use for the containers in the task.
     */
    public final String pidMode() {
        return pidMode;
    }

    /**
     * <p>
     * The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2
     * resources must not specify this parameter.
     * </p>
     * 
     * @return The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon
     *         EC2 resources must not specify this parameter.
     */
    public final NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * An object that represents the compute environment architecture for Batch jobs on Fargate.
     * </p>
     * 
     * @return An object that represents the compute environment architecture for Batch jobs on Fargate.
     */
    public final RuntimePlatform runtimePlatform() {
        return runtimePlatform;
    }

    /**
     * For responses, this returns true if the service returned a value for the Volumes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVolumes() {
        return volumes != null && !(volumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of data volumes used in a job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumes} method.
     * </p>
     * 
     * @return A list of data volumes used in a job.
     */
    public final List<Volume> volumes() {
        return volumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(containerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(ipcMode());
        hashCode = 31 * hashCode + Objects.hashCode(taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(pidMode());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(runtimePlatform());
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumes() ? volumes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsTaskDetails)) {
            return false;
        }
        EcsTaskDetails other = (EcsTaskDetails) obj;
        return hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers())
                && Objects.equals(containerInstanceArn(), other.containerInstanceArn())
                && Objects.equals(taskArn(), other.taskArn()) && Objects.equals(ephemeralStorage(), other.ephemeralStorage())
                && Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(platformVersion(), other.platformVersion()) && Objects.equals(ipcMode(), other.ipcMode())
                && Objects.equals(taskRoleArn(), other.taskRoleArn()) && Objects.equals(pidMode(), other.pidMode())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(runtimePlatform(), other.runtimePlatform()) && hasVolumes() == other.hasVolumes()
                && Objects.equals(volumes(), other.volumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcsTaskDetails").add("Containers", hasContainers() ? containers() : null)
                .add("ContainerInstanceArn", containerInstanceArn()).add("TaskArn", taskArn())
                .add("EphemeralStorage", ephemeralStorage()).add("ExecutionRoleArn", executionRoleArn())
                .add("PlatformVersion", platformVersion()).add("IpcMode", ipcMode()).add("TaskRoleArn", taskRoleArn())
                .add("PidMode", pidMode()).add("NetworkConfiguration", networkConfiguration())
                .add("RuntimePlatform", runtimePlatform()).add("Volumes", hasVolumes() ? volumes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "containerInstanceArn":
            return Optional.ofNullable(clazz.cast(containerInstanceArn()));
        case "taskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "ephemeralStorage":
            return Optional.ofNullable(clazz.cast(ephemeralStorage()));
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "ipcMode":
            return Optional.ofNullable(clazz.cast(ipcMode()));
        case "taskRoleArn":
            return Optional.ofNullable(clazz.cast(taskRoleArn()));
        case "pidMode":
            return Optional.ofNullable(clazz.cast(pidMode()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "runtimePlatform":
            return Optional.ofNullable(clazz.cast(runtimePlatform()));
        case "volumes":
            return Optional.ofNullable(clazz.cast(volumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcsTaskDetails, T> g) {
        return obj -> g.apply((EcsTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcsTaskDetails> {
        /**
         * <p>
         * A list of containers that are included in the <code>taskProperties</code> list.
         * </p>
         * 
         * @param containers
         *        A list of containers that are included in the <code>taskProperties</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<TaskContainerDetails> containers);

        /**
         * <p>
         * A list of containers that are included in the <code>taskProperties</code> list.
         * </p>
         * 
         * @param containers
         *        A list of containers that are included in the <code>taskProperties</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(TaskContainerDetails... containers);

        /**
         * <p>
         * A list of containers that are included in the <code>taskProperties</code> list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.TaskContainerDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.batch.model.TaskContainerDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.TaskContainerDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #containers(List<TaskContainerDetails>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.TaskContainerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<TaskContainerDetails>)
         */
        Builder containers(Consumer<TaskContainerDetails.Builder>... containers);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the container instance that hosts the task.
         * </p>
         * 
         * @param containerInstanceArn
         *        The Amazon Resource Name (ARN) of the container instance that hosts the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerInstanceArn(String containerInstanceArn);

        /**
         * <p>
         * The ARN of the Amazon ECS task.
         * </p>
         * 
         * @param taskArn
         *        The ARN of the Amazon ECS task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The amount of ephemeral storage allocated for the task.
         * </p>
         * 
         * @param ephemeralStorage
         *        The amount of ephemeral storage allocated for the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemeralStorage(EphemeralStorage ephemeralStorage);

        /**
         * <p>
         * The amount of ephemeral storage allocated for the task.
         * </p>
         * This is a convenience method that creates an instance of the {@link EphemeralStorage.Builder} avoiding the
         * need to create one manually via {@link EphemeralStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EphemeralStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #ephemeralStorage(EphemeralStorage)}.
         * 
         * @param ephemeralStorage
         *        a consumer that will call methods on {@link EphemeralStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ephemeralStorage(EphemeralStorage)
         */
        default Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return ephemeralStorage(EphemeralStorage.builder().applyMutation(ephemeralStorage).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution role that Batch can assume. For more information, see <a
         * href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">Batch execution IAM
         * role</a> in the <i>Batch User Guide</i>.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the execution role that Batch can assume. For more information, see
         *        <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">Batch execution
         *        IAM role</a> in the <i>Batch User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Fargate platform version where the jobs are running.
         * </p>
         * 
         * @param platformVersion
         *        The Fargate platform version where the jobs are running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The IPC resource namespace to use for the containers in the task.
         * </p>
         * 
         * @param ipcMode
         *        The IPC resource namespace to use for the containers in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipcMode(String ipcMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that the container can assume for Amazon Web Services
         * permissions. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM roles for
         * tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * This is object is comparable to <a
         * href="https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html"
         * >ContainerProperties:jobRoleArn</a>.
         * </p>
         * </note>
         * 
         * @param taskRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that the container can assume for Amazon Web Services
         *        permissions. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM roles for
         *        tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> <note>
         *        <p>
         *        This is object is comparable to <a
         *        href="https://docs.aws.amazon.com/batch/latest/APIReference/API_ContainerProperties.html"
         *        >ContainerProperties:jobRoleArn</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRoleArn(String taskRoleArn);

        /**
         * <p>
         * The process namespace to use for the containers in the task.
         * </p>
         * 
         * @param pidMode
         *        The process namespace to use for the containers in the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pidMode(String pidMode);

        /**
         * <p>
         * The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2
         * resources must not specify this parameter.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for jobs that are running on Fargate resources. Jobs that are running on
         *        Amazon EC2 resources must not specify this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for jobs that are running on Fargate resources. Jobs that are running on Amazon EC2
         * resources must not specify this parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * An object that represents the compute environment architecture for Batch jobs on Fargate.
         * </p>
         * 
         * @param runtimePlatform
         *        An object that represents the compute environment architecture for Batch jobs on Fargate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimePlatform(RuntimePlatform runtimePlatform);

        /**
         * <p>
         * An object that represents the compute environment architecture for Batch jobs on Fargate.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuntimePlatform.Builder} avoiding the
         * need to create one manually via {@link RuntimePlatform#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuntimePlatform.Builder#build()} is called immediately and its
         * result is passed to {@link #runtimePlatform(RuntimePlatform)}.
         * 
         * @param runtimePlatform
         *        a consumer that will call methods on {@link RuntimePlatform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimePlatform(RuntimePlatform)
         */
        default Builder runtimePlatform(Consumer<RuntimePlatform.Builder> runtimePlatform) {
            return runtimePlatform(RuntimePlatform.builder().applyMutation(runtimePlatform).build());
        }

        /**
         * <p>
         * A list of data volumes used in a job.
         * </p>
         * 
         * @param volumes
         *        A list of data volumes used in a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<Volume> volumes);

        /**
         * <p>
         * A list of data volumes used in a job.
         * </p>
         * 
         * @param volumes
         *        A list of data volumes used in a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Volume... volumes);

        /**
         * <p>
         * A list of data volumes used in a job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.batch.model.Volume.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.batch.model.Volume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.batch.model.Volume.Builder#build()} is called immediately and its
         * result is passed to {@link #volumes(List<Volume>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.batch.model.Volume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(java.util.Collection<Volume>)
         */
        Builder volumes(Consumer<Volume.Builder>... volumes);
    }

    static final class BuilderImpl implements Builder {
        private List<TaskContainerDetails> containers = DefaultSdkAutoConstructList.getInstance();

        private String containerInstanceArn;

        private String taskArn;

        private EphemeralStorage ephemeralStorage;

        private String executionRoleArn;

        private String platformVersion;

        private String ipcMode;

        private String taskRoleArn;

        private String pidMode;

        private NetworkConfiguration networkConfiguration;

        private RuntimePlatform runtimePlatform;

        private List<Volume> volumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EcsTaskDetails model) {
            containers(model.containers);
            containerInstanceArn(model.containerInstanceArn);
            taskArn(model.taskArn);
            ephemeralStorage(model.ephemeralStorage);
            executionRoleArn(model.executionRoleArn);
            platformVersion(model.platformVersion);
            ipcMode(model.ipcMode);
            taskRoleArn(model.taskRoleArn);
            pidMode(model.pidMode);
            networkConfiguration(model.networkConfiguration);
            runtimePlatform(model.runtimePlatform);
            volumes(model.volumes);
        }

        public final List<TaskContainerDetails.Builder> getContainers() {
            List<TaskContainerDetails.Builder> result = ListTaskContainerDetailsCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<TaskContainerDetails.BuilderImpl> containers) {
            this.containers = ListTaskContainerDetailsCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<TaskContainerDetails> containers) {
            this.containers = ListTaskContainerDetailsCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(TaskContainerDetails... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<TaskContainerDetails.Builder>... containers) {
            containers(Stream.of(containers).map(c -> TaskContainerDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getContainerInstanceArn() {
            return containerInstanceArn;
        }

        public final void setContainerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
        }

        @Override
        public final Builder containerInstanceArn(String containerInstanceArn) {
            this.containerInstanceArn = containerInstanceArn;
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return ephemeralStorage != null ? ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getIpcMode() {
            return ipcMode;
        }

        public final void setIpcMode(String ipcMode) {
            this.ipcMode = ipcMode;
        }

        @Override
        public final Builder ipcMode(String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        public final String getTaskRoleArn() {
            return taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final String getPidMode() {
            return pidMode;
        }

        public final void setPidMode(String pidMode) {
            this.pidMode = pidMode;
        }

        @Override
        public final Builder pidMode(String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final RuntimePlatform.Builder getRuntimePlatform() {
            return runtimePlatform != null ? runtimePlatform.toBuilder() : null;
        }

        public final void setRuntimePlatform(RuntimePlatform.BuilderImpl runtimePlatform) {
            this.runtimePlatform = runtimePlatform != null ? runtimePlatform.build() : null;
        }

        @Override
        public final Builder runtimePlatform(RuntimePlatform runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        public final List<Volume.Builder> getVolumes() {
            List<Volume.Builder> result = VolumesCopier.copyToBuilder(this.volumes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumes(Collection<Volume.BuilderImpl> volumes) {
            this.volumes = VolumesCopier.copyFromBuilder(volumes);
        }

        @Override
        public final Builder volumes(Collection<Volume> volumes) {
            this.volumes = VolumesCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Volume... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<Volume.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> Volume.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EcsTaskDetails build() {
            return new EcsTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
