/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Origination settings enable your SIP hosts to receive inbound calls using your Amazon Chime SDK Voice Connector.
 * </p>
 * <note>
 * <p>
 * The parameters listed below are not required, but you must use at least one.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Origination implements SdkPojo, Serializable, ToCopyableBuilder<Origination.Builder, Origination> {
    private static final SdkField<List<OriginationRoute>> ROUTES_FIELD = SdkField
            .<List<OriginationRoute>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(Origination::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OriginationRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(OriginationRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Disabled").getter(getter(Origination::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTES_FIELD, DISABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<OriginationRoute> routes;

    private final Boolean disabled;

    private Origination(BuilderImpl builder) {
        this.routes = builder.routes;
        this.disabled = builder.disabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum value of
     * 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum
     *         value of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>
     *         .
     */
    public final List<OriginationRoute> routes() {
        return routes;
    }

    /**
     * <p>
     * When origination settings are disabled, inbound calls are not enabled for your Amazon Chime SDK Voice Connector.
     * This parameter is not required, but you must specify this parameter or <code>Routes</code>.
     * </p>
     * 
     * @return When origination settings are disabled, inbound calls are not enabled for your Amazon Chime SDK Voice
     *         Connector. This parameter is not required, but you must specify this parameter or <code>Routes</code>.
     */
    public final Boolean disabled() {
        return disabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origination)) {
            return false;
        }
        Origination other = (Origination) obj;
        return hasRoutes() == other.hasRoutes() && Objects.equals(routes(), other.routes())
                && Objects.equals(disabled(), other.disabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Origination").add("Routes", hasRoutes() ? routes() : null).add("Disabled", disabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Origination, T> g) {
        return obj -> g.apply((Origination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Origination> {
        /**
         * <p>
         * The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum value
         * of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.
         * </p>
         * 
         * @param routes
         *        The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum
         *        value of 20. This parameter is not required, but you must specify this parameter or
         *        <code>Disabled</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<OriginationRoute> routes);

        /**
         * <p>
         * The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum value
         * of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.
         * </p>
         * 
         * @param routes
         *        The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum
         *        value of 20. This parameter is not required, but you must specify this parameter or
         *        <code>Disabled</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(OriginationRoute... routes);

        /**
         * <p>
         * The call distribution properties defined for your SIP hosts. Valid range: Minimum value of 1. Maximum value
         * of 20. This parameter is not required, but you must specify this parameter or <code>Disabled</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.OriginationRoute.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.OriginationRoute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.chimesdkvoice.model.OriginationRoute.Builder#build()} is called
         * immediately and its result is passed to {@link #routes(List<OriginationRoute>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.chimesdkvoice.model.OriginationRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<OriginationRoute>)
         */
        Builder routes(Consumer<OriginationRoute.Builder>... routes);

        /**
         * <p>
         * When origination settings are disabled, inbound calls are not enabled for your Amazon Chime SDK Voice
         * Connector. This parameter is not required, but you must specify this parameter or <code>Routes</code>.
         * </p>
         * 
         * @param disabled
         *        When origination settings are disabled, inbound calls are not enabled for your Amazon Chime SDK Voice
         *        Connector. This parameter is not required, but you must specify this parameter or <code>Routes</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);
    }

    static final class BuilderImpl implements Builder {
        private List<OriginationRoute> routes = DefaultSdkAutoConstructList.getInstance();

        private Boolean disabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Origination model) {
            routes(model.routes);
            disabled(model.disabled);
        }

        public final List<OriginationRoute.Builder> getRoutes() {
            List<OriginationRoute.Builder> result = OriginationRouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<OriginationRoute.BuilderImpl> routes) {
            this.routes = OriginationRouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<OriginationRoute> routes) {
            this.routes = OriginationRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(OriginationRoute... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<OriginationRoute.Builder>... routes) {
            routes(Stream.of(routes).map(c -> OriginationRoute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public Origination build() {
            return new Origination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
