/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a speaker search analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpeakerSearchResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SpeakerSearchResult.Builder, SpeakerSearchResult> {
    private static final SdkField<Float> CONFIDENCE_SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("ConfidenceScore").getter(getter(SpeakerSearchResult::confidenceScore))
            .setter(setter(Builder::confidenceScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfidenceScore").build()).build();

    private static final SdkField<String> VOICE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceProfileId").getter(getter(SpeakerSearchResult::voiceProfileId))
            .setter(setter(Builder::voiceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIDENCE_SCORE_FIELD,
            VOICE_PROFILE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Float confidenceScore;

    private final String voiceProfileId;

    private SpeakerSearchResult(BuilderImpl builder) {
        this.confidenceScore = builder.confidenceScore;
        this.voiceProfileId = builder.voiceProfileId;
    }

    /**
     * <p>
     * The confidence score in the speaker search analysis.
     * </p>
     * 
     * @return The confidence score in the speaker search analysis.
     */
    public final Float confidenceScore() {
        return confidenceScore;
    }

    /**
     * <p>
     * The voice profile ID.
     * </p>
     * 
     * @return The voice profile ID.
     */
    public final String voiceProfileId() {
        return voiceProfileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(confidenceScore());
        hashCode = 31 * hashCode + Objects.hashCode(voiceProfileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpeakerSearchResult)) {
            return false;
        }
        SpeakerSearchResult other = (SpeakerSearchResult) obj;
        return Objects.equals(confidenceScore(), other.confidenceScore())
                && Objects.equals(voiceProfileId(), other.voiceProfileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpeakerSearchResult").add("ConfidenceScore", confidenceScore())
                .add("VoiceProfileId", voiceProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfidenceScore":
            return Optional.ofNullable(clazz.cast(confidenceScore()));
        case "VoiceProfileId":
            return Optional.ofNullable(clazz.cast(voiceProfileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpeakerSearchResult, T> g) {
        return obj -> g.apply((SpeakerSearchResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpeakerSearchResult> {
        /**
         * <p>
         * The confidence score in the speaker search analysis.
         * </p>
         * 
         * @param confidenceScore
         *        The confidence score in the speaker search analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidenceScore(Float confidenceScore);

        /**
         * <p>
         * The voice profile ID.
         * </p>
         * 
         * @param voiceProfileId
         *        The voice profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceProfileId(String voiceProfileId);
    }

    static final class BuilderImpl implements Builder {
        private Float confidenceScore;

        private String voiceProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(SpeakerSearchResult model) {
            confidenceScore(model.confidenceScore);
            voiceProfileId(model.voiceProfileId);
        }

        public final Float getConfidenceScore() {
            return confidenceScore;
        }

        public final void setConfidenceScore(Float confidenceScore) {
            this.confidenceScore = confidenceScore;
        }

        @Override
        public final Builder confidenceScore(Float confidenceScore) {
            this.confidenceScore = confidenceScore;
            return this;
        }

        public final String getVoiceProfileId() {
            return voiceProfileId;
        }

        public final void setVoiceProfileId(String voiceProfileId) {
            this.voiceProfileId = voiceProfileId;
        }

        @Override
        public final Builder voiceProfileId(String voiceProfileId) {
            this.voiceProfileId = voiceProfileId;
            return this;
        }

        @Override
        public SpeakerSearchResult build() {
            return new SpeakerSearchResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
