/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeResponse;

public class ListDistributionsByConnectionModeIterable
implements SdkIterable<ListDistributionsByConnectionModeResponse> {
    private final CloudFrontClient client;
    private final ListDistributionsByConnectionModeRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDistributionsByConnectionModeIterable(CloudFrontClient client, ListDistributionsByConnectionModeRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDistributionsByConnectionModeResponseFetcher();
    }

    public Iterator<ListDistributionsByConnectionModeResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DistributionSummary> items() {
        Function<ListDistributionsByConnectionModeResponse, Iterator> getIterator = response -> {
            if (response != null && response.distributionList() != null && response.distributionList().items() != null) {
                return response.distributionList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDistributionsByConnectionModeResponseFetcher
    implements SyncPageFetcher<ListDistributionsByConnectionModeResponse> {
        private ListDistributionsByConnectionModeResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsByConnectionModeResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.distributionList().nextMarker());
        }

        public ListDistributionsByConnectionModeResponse nextPage(ListDistributionsByConnectionModeResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsByConnectionModeIterable.this.client.listDistributionsByConnectionMode(ListDistributionsByConnectionModeIterable.this.firstRequest);
            }
            return ListDistributionsByConnectionModeIterable.this.client.listDistributionsByConnectionMode((ListDistributionsByConnectionModeRequest)((Object)ListDistributionsByConnectionModeIterable.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

