/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the information about your continuous deployment policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinuousDeploymentPolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ContinuousDeploymentPolicySummary.Builder, ContinuousDeploymentPolicySummary> {
    private static final SdkField<ContinuousDeploymentPolicy> CONTINUOUS_DEPLOYMENT_POLICY_FIELD = SdkField
            .<ContinuousDeploymentPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("ContinuousDeploymentPolicy")
            .getter(getter(ContinuousDeploymentPolicySummary::continuousDeploymentPolicy))
            .setter(setter(Builder::continuousDeploymentPolicy))
            .constructor(ContinuousDeploymentPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousDeploymentPolicy")
                    .unmarshallLocationName("ContinuousDeploymentPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONTINUOUS_DEPLOYMENT_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ContinuousDeploymentPolicy continuousDeploymentPolicy;

    private ContinuousDeploymentPolicySummary(BuilderImpl builder) {
        this.continuousDeploymentPolicy = builder.continuousDeploymentPolicy;
    }

    /**
     * <p>
     * The continuous deployment policy.
     * </p>
     * 
     * @return The continuous deployment policy.
     */
    public final ContinuousDeploymentPolicy continuousDeploymentPolicy() {
        return continuousDeploymentPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continuousDeploymentPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousDeploymentPolicySummary)) {
            return false;
        }
        ContinuousDeploymentPolicySummary other = (ContinuousDeploymentPolicySummary) obj;
        return Objects.equals(continuousDeploymentPolicy(), other.continuousDeploymentPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContinuousDeploymentPolicySummary")
                .add("ContinuousDeploymentPolicy", continuousDeploymentPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinuousDeploymentPolicy":
            return Optional.ofNullable(clazz.cast(continuousDeploymentPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContinuousDeploymentPolicy", CONTINUOUS_DEPLOYMENT_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContinuousDeploymentPolicySummary, T> g) {
        return obj -> g.apply((ContinuousDeploymentPolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinuousDeploymentPolicySummary> {
        /**
         * <p>
         * The continuous deployment policy.
         * </p>
         * 
         * @param continuousDeploymentPolicy
         *        The continuous deployment policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousDeploymentPolicy(ContinuousDeploymentPolicy continuousDeploymentPolicy);

        /**
         * <p>
         * The continuous deployment policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContinuousDeploymentPolicy.Builder}
         * avoiding the need to create one manually via {@link ContinuousDeploymentPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContinuousDeploymentPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #continuousDeploymentPolicy(ContinuousDeploymentPolicy)}.
         * 
         * @param continuousDeploymentPolicy
         *        a consumer that will call methods on {@link ContinuousDeploymentPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continuousDeploymentPolicy(ContinuousDeploymentPolicy)
         */
        default Builder continuousDeploymentPolicy(Consumer<ContinuousDeploymentPolicy.Builder> continuousDeploymentPolicy) {
            return continuousDeploymentPolicy(ContinuousDeploymentPolicy.builder().applyMutation(continuousDeploymentPolicy)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContinuousDeploymentPolicy continuousDeploymentPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousDeploymentPolicySummary model) {
            continuousDeploymentPolicy(model.continuousDeploymentPolicy);
        }

        public final ContinuousDeploymentPolicy.Builder getContinuousDeploymentPolicy() {
            return continuousDeploymentPolicy != null ? continuousDeploymentPolicy.toBuilder() : null;
        }

        public final void setContinuousDeploymentPolicy(ContinuousDeploymentPolicy.BuilderImpl continuousDeploymentPolicy) {
            this.continuousDeploymentPolicy = continuousDeploymentPolicy != null ? continuousDeploymentPolicy.build() : null;
        }

        @Override
        public final Builder continuousDeploymentPolicy(ContinuousDeploymentPolicy continuousDeploymentPolicy) {
            this.continuousDeploymentPolicy = continuousDeploymentPolicy;
            return this;
        }

        @Override
        public ContinuousDeploymentPolicySummary build() {
            return new ContinuousDeploymentPolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
