/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter by the associated distribution ID or connection group ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistributionTenantAssociationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DistributionTenantAssociationFilter.Builder, DistributionTenantAssociationFilter> {
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DistributionId")
            .getter(getter(DistributionTenantAssociationFilter::distributionId))
            .setter(setter(Builder::distributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionId")
                    .unmarshallLocationName("DistributionId").build()).build();

    private static final SdkField<String> CONNECTION_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConnectionGroupId")
            .getter(getter(DistributionTenantAssociationFilter::connectionGroupId))
            .setter(setter(Builder::connectionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionGroupId")
                    .unmarshallLocationName("ConnectionGroupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTRIBUTION_ID_FIELD,
            CONNECTION_GROUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String distributionId;

    private final String connectionGroupId;

    private DistributionTenantAssociationFilter(BuilderImpl builder) {
        this.distributionId = builder.distributionId;
        this.connectionGroupId = builder.connectionGroupId;
    }

    /**
     * <p>
     * The distribution ID to filter by. You can find distribution tenants associated with a specific distribution.
     * </p>
     * 
     * @return The distribution ID to filter by. You can find distribution tenants associated with a specific
     *         distribution.
     */
    public final String distributionId() {
        return distributionId;
    }

    /**
     * <p>
     * The ID of the connection group to filter by. You can find distribution tenants associated with a specific
     * connection group.
     * </p>
     * 
     * @return The ID of the connection group to filter by. You can find distribution tenants associated with a specific
     *         connection group.
     */
    public final String connectionGroupId() {
        return connectionGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionTenantAssociationFilter)) {
            return false;
        }
        DistributionTenantAssociationFilter other = (DistributionTenantAssociationFilter) obj;
        return Objects.equals(distributionId(), other.distributionId())
                && Objects.equals(connectionGroupId(), other.connectionGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DistributionTenantAssociationFilter").add("DistributionId", distributionId())
                .add("ConnectionGroupId", connectionGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DistributionId":
            return Optional.ofNullable(clazz.cast(distributionId()));
        case "ConnectionGroupId":
            return Optional.ofNullable(clazz.cast(connectionGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DistributionId", DISTRIBUTION_ID_FIELD);
        map.put("ConnectionGroupId", CONNECTION_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistributionTenantAssociationFilter, T> g) {
        return obj -> g.apply((DistributionTenantAssociationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DistributionTenantAssociationFilter> {
        /**
         * <p>
         * The distribution ID to filter by. You can find distribution tenants associated with a specific distribution.
         * </p>
         * 
         * @param distributionId
         *        The distribution ID to filter by. You can find distribution tenants associated with a specific
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distributionId(String distributionId);

        /**
         * <p>
         * The ID of the connection group to filter by. You can find distribution tenants associated with a specific
         * connection group.
         * </p>
         * 
         * @param connectionGroupId
         *        The ID of the connection group to filter by. You can find distribution tenants associated with a
         *        specific connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionGroupId(String connectionGroupId);
    }

    static final class BuilderImpl implements Builder {
        private String distributionId;

        private String connectionGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionTenantAssociationFilter model) {
            distributionId(model.distributionId);
            connectionGroupId(model.connectionGroupId);
        }

        public final String getDistributionId() {
            return distributionId;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final String getConnectionGroupId() {
            return connectionGroupId;
        }

        public final void setConnectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
        }

        @Override
        public final Builder connectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
            return this;
        }

        @Override
        public DistributionTenantAssociationFilter build() {
            return new DistributionTenantAssociationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
