/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A streaming distribution tells CloudFront where you want RTMP content to be delivered from, and the details about how
 * to track and manage content delivery.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingDistribution implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingDistribution.Builder, StreamingDistribution> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(StreamingDistribution::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ARN")
            .getter(getter(StreamingDistribution::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(StreamingDistribution::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(StreamingDistribution::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DomainName")
            .getter(getter(StreamingDistribution::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName")
                    .unmarshallLocationName("DomainName").build()).build();

    private static final SdkField<ActiveTrustedSigners> ACTIVE_TRUSTED_SIGNERS_FIELD = SdkField
            .<ActiveTrustedSigners> builder(MarshallingType.SDK_POJO)
            .memberName("ActiveTrustedSigners")
            .getter(getter(StreamingDistribution::activeTrustedSigners))
            .setter(setter(Builder::activeTrustedSigners))
            .constructor(ActiveTrustedSigners::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveTrustedSigners")
                    .unmarshallLocationName("ActiveTrustedSigners").build()).build();

    private static final SdkField<StreamingDistributionConfig> STREAMING_DISTRIBUTION_CONFIG_FIELD = SdkField
            .<StreamingDistributionConfig> builder(MarshallingType.SDK_POJO)
            .memberName("StreamingDistributionConfig")
            .getter(getter(StreamingDistribution::streamingDistributionConfig))
            .setter(setter(Builder::streamingDistributionConfig))
            .constructor(StreamingDistributionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistributionConfig")
                    .unmarshallLocationName("StreamingDistributionConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, DOMAIN_NAME_FIELD, ACTIVE_TRUSTED_SIGNERS_FIELD,
            STREAMING_DISTRIBUTION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String status;

    private final Instant lastModifiedTime;

    private final String domainName;

    private final ActiveTrustedSigners activeTrustedSigners;

    private final StreamingDistributionConfig streamingDistributionConfig;

    private StreamingDistribution(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.activeTrustedSigners = builder.activeTrustedSigners;
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
    }

    /**
     * <p>
     * The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
     * </p>
     * 
     * @return The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) for the distribution. For example:
     * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code> is
     * your Amazon Web Services account ID.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) for the distribution. For example:
     *         <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
     *         <code>123456789012</code> is your Amazon Web Services account ID.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution's
     * information is propagated to all CloudFront edge locations.
     * </p>
     * 
     * @return The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution's
     *         information is propagated to all CloudFront edge locations.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The date and time that the distribution was last modified.
     * </p>
     * 
     * @return The date and time that the distribution was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The domain name that corresponds to the streaming distribution, for example,
     * <code>s5c39gqb8ow64r.cloudfront.net</code>.
     * </p>
     * 
     * @return The domain name that corresponds to the streaming distribution, for example,
     *         <code>s5c39gqb8ow64r.cloudfront.net</code>.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A complex type that lists the Amazon Web Services accounts, if any, that you included in the
     * <code>TrustedSigners</code> complex type for this distribution. These are the accounts that you want to allow to
     * create signed URLs for private content.
     * </p>
     * <p>
     * The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted signer or
     * <code>self</code> if the signer is the Amazon Web Services account that created the distribution. The
     * <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are associated with the
     * trusted signer's Amazon Web Services account. If no <code>KeyPairId</code> element appears for a
     * <code>Signer</code>, that signer can't create signed URLs.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that lists the Amazon Web Services accounts, if any, that you included in the
     *         <code>TrustedSigners</code> complex type for this distribution. These are the accounts that you want to
     *         allow to create signed URLs for private content.</p>
     *         <p>
     *         The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted signer
     *         or <code>self</code> if the signer is the Amazon Web Services account that created the distribution. The
     *         <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are associated
     *         with the trusted signer's Amazon Web Services account. If no <code>KeyPairId</code> element appears for a
     *         <code>Signer</code>, that signer can't create signed URLs.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
     *         Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final ActiveTrustedSigners activeTrustedSigners() {
        return activeTrustedSigners;
    }

    /**
     * <p>
     * The current configuration information for the RTMP distribution.
     * </p>
     * 
     * @return The current configuration information for the RTMP distribution.
     */
    public final StreamingDistributionConfig streamingDistributionConfig() {
        return streamingDistributionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(activeTrustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(streamingDistributionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistribution)) {
            return false;
        }
        StreamingDistribution other = (StreamingDistribution) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(status(), other.status())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(domainName(), other.domainName())
                && Objects.equals(activeTrustedSigners(), other.activeTrustedSigners())
                && Objects.equals(streamingDistributionConfig(), other.streamingDistributionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingDistribution").add("Id", id()).add("ARN", arn()).add("Status", status())
                .add("LastModifiedTime", lastModifiedTime()).add("DomainName", domainName())
                .add("ActiveTrustedSigners", activeTrustedSigners())
                .add("StreamingDistributionConfig", streamingDistributionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ARN":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ActiveTrustedSigners":
            return Optional.ofNullable(clazz.cast(activeTrustedSigners()));
        case "StreamingDistributionConfig":
            return Optional.ofNullable(clazz.cast(streamingDistributionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ActiveTrustedSigners", ACTIVE_TRUSTED_SIGNERS_FIELD);
        map.put("StreamingDistributionConfig", STREAMING_DISTRIBUTION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamingDistribution, T> g) {
        return obj -> g.apply((StreamingDistribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingDistribution> {
        /**
         * <p>
         * The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
         * </p>
         * 
         * @param id
         *        The identifier for the RTMP distribution. For example: <code>EGTXBD79EXAMPLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) for the distribution. For example:
         * <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where <code>123456789012</code>
         * is your Amazon Web Services account ID.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) for the distribution. For example:
         *        <code>arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5</code>, where
         *        <code>123456789012</code> is your Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current status of the RTMP distribution. When the status is <code>Deployed</code>, the distribution's
         * information is propagated to all CloudFront edge locations.
         * </p>
         * 
         * @param status
         *        The current status of the RTMP distribution. When the status is <code>Deployed</code>, the
         *        distribution's information is propagated to all CloudFront edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The date and time that the distribution was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the distribution was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The domain name that corresponds to the streaming distribution, for example,
         * <code>s5c39gqb8ow64r.cloudfront.net</code>.
         * </p>
         * 
         * @param domainName
         *        The domain name that corresponds to the streaming distribution, for example,
         *        <code>s5c39gqb8ow64r.cloudfront.net</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A complex type that lists the Amazon Web Services accounts, if any, that you included in the
         * <code>TrustedSigners</code> complex type for this distribution. These are the accounts that you want to allow
         * to create signed URLs for private content.
         * </p>
         * <p>
         * The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted signer or
         * <code>self</code> if the signer is the Amazon Web Services account that created the distribution. The
         * <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are associated with
         * the trusted signer's Amazon Web Services account. If no <code>KeyPairId</code> element appears for a
         * <code>Signer</code>, that signer can't create signed URLs.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param activeTrustedSigners
         *        A complex type that lists the Amazon Web Services accounts, if any, that you included in the
         *        <code>TrustedSigners</code> complex type for this distribution. These are the accounts that you want
         *        to allow to create signed URLs for private content.</p>
         *        <p>
         *        The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted
         *        signer or <code>self</code> if the signer is the Amazon Web Services account that created the
         *        distribution. The <code>Signer</code> element also includes the IDs of any active CloudFront key pairs
         *        that are associated with the trusted signer's Amazon Web Services account. If no
         *        <code>KeyPairId</code> element appears for a <code>Signer</code>, that signer can't create signed
         *        URLs.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving
         *        Private Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners);

        /**
         * <p>
         * A complex type that lists the Amazon Web Services accounts, if any, that you included in the
         * <code>TrustedSigners</code> complex type for this distribution. These are the accounts that you want to allow
         * to create signed URLs for private content.
         * </p>
         * <p>
         * The <code>Signer</code> complex type lists the Amazon Web Services account number of the trusted signer or
         * <code>self</code> if the signer is the Amazon Web Services account that created the distribution. The
         * <code>Signer</code> element also includes the IDs of any active CloudFront key pairs that are associated with
         * the trusted signer's Amazon Web Services account. If no <code>KeyPairId</code> element appears for a
         * <code>Signer</code>, that signer can't create signed URLs.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
         * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActiveTrustedSigners.Builder} avoiding
         * the need to create one manually via {@link ActiveTrustedSigners#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActiveTrustedSigners.Builder#build()} is called immediately and
         * its result is passed to {@link #activeTrustedSigners(ActiveTrustedSigners)}.
         * 
         * @param activeTrustedSigners
         *        a consumer that will call methods on {@link ActiveTrustedSigners.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeTrustedSigners(ActiveTrustedSigners)
         */
        default Builder activeTrustedSigners(Consumer<ActiveTrustedSigners.Builder> activeTrustedSigners) {
            return activeTrustedSigners(ActiveTrustedSigners.builder().applyMutation(activeTrustedSigners).build());
        }

        /**
         * <p>
         * The current configuration information for the RTMP distribution.
         * </p>
         * 
         * @param streamingDistributionConfig
         *        The current configuration information for the RTMP distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig);

        /**
         * <p>
         * The current configuration information for the RTMP distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamingDistributionConfig.Builder}
         * avoiding the need to create one manually via {@link StreamingDistributionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamingDistributionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #streamingDistributionConfig(StreamingDistributionConfig)}.
         * 
         * @param streamingDistributionConfig
         *        a consumer that will call methods on {@link StreamingDistributionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamingDistributionConfig(StreamingDistributionConfig)
         */
        default Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return streamingDistributionConfig(StreamingDistributionConfig.builder().applyMutation(streamingDistributionConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant lastModifiedTime;

        private String domainName;

        private ActiveTrustedSigners activeTrustedSigners;

        private StreamingDistributionConfig streamingDistributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistribution model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            domainName(model.domainName);
            activeTrustedSigners(model.activeTrustedSigners);
            streamingDistributionConfig(model.streamingDistributionConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final ActiveTrustedSigners.Builder getActiveTrustedSigners() {
            return activeTrustedSigners != null ? activeTrustedSigners.toBuilder() : null;
        }

        public final void setActiveTrustedSigners(ActiveTrustedSigners.BuilderImpl activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners != null ? activeTrustedSigners.build() : null;
        }

        @Override
        public final Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners;
            return this;
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return streamingDistributionConfig != null ? streamingDistributionConfig.toBuilder() : null;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        @Override
        public StreamingDistribution build() {
            return new StreamingDistribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
