/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResponseHeadersPolicyRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateResponseHeadersPolicyRequest.Builder, UpdateResponseHeadersPolicyRequest> {
    private static final SdkField<ResponseHeadersPolicyConfig> RESPONSE_HEADERS_POLICY_CONFIG_FIELD = SdkField
            .<ResponseHeadersPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ResponseHeadersPolicyConfig")
            .getter(getter(UpdateResponseHeadersPolicyRequest::responseHeadersPolicyConfig))
            .setter(setter(Builder::responseHeadersPolicyConfig))
            .constructor(ResponseHeadersPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicyConfig")
                    .unmarshallLocationName("ResponseHeadersPolicyConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateResponseHeadersPolicyRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateResponseHeadersPolicyRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESPONSE_HEADERS_POLICY_CONFIG_FIELD, ID_FIELD, IF_MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ResponseHeadersPolicyConfig responseHeadersPolicyConfig;

    private final String id;

    private final String ifMatch;

    private UpdateResponseHeadersPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.responseHeadersPolicyConfig = builder.responseHeadersPolicyConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * A response headers policy configuration.
     * </p>
     * 
     * @return A response headers policy configuration.
     */
    public final ResponseHeadersPolicyConfig responseHeadersPolicyConfig() {
        return responseHeadersPolicyConfig;
    }

    /**
     * <p>
     * The identifier for the response headers policy that you are updating.
     * </p>
     * 
     * @return The identifier for the response headers policy that you are updating.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The version of the response headers policy that you are updating.
     * </p>
     * <p>
     * The version is returned in the cache policy's <code>ETag</code> field in the response to
     * <code>GetResponseHeadersPolicyConfig</code>.
     * </p>
     * 
     * @return The version of the response headers policy that you are updating.</p>
     *         <p>
     *         The version is returned in the cache policy's <code>ETag</code> field in the response to
     *         <code>GetResponseHeadersPolicyConfig</code>.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(responseHeadersPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResponseHeadersPolicyRequest)) {
            return false;
        }
        UpdateResponseHeadersPolicyRequest other = (UpdateResponseHeadersPolicyRequest) obj;
        return Objects.equals(responseHeadersPolicyConfig(), other.responseHeadersPolicyConfig())
                && Objects.equals(id(), other.id()) && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResponseHeadersPolicyRequest")
                .add("ResponseHeadersPolicyConfig", responseHeadersPolicyConfig()).add("Id", id()).add("IfMatch", ifMatch())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResponseHeadersPolicyConfig":
            return Optional.ofNullable(clazz.cast(responseHeadersPolicyConfig()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResponseHeadersPolicyConfig", RESPONSE_HEADERS_POLICY_CONFIG_FIELD);
        map.put("Id", ID_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResponseHeadersPolicyRequest, T> g) {
        return obj -> g.apply((UpdateResponseHeadersPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResponseHeadersPolicyRequest> {
        /**
         * <p>
         * A response headers policy configuration.
         * </p>
         * 
         * @param responseHeadersPolicyConfig
         *        A response headers policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig responseHeadersPolicyConfig);

        /**
         * <p>
         * A response headers policy configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseHeadersPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link ResponseHeadersPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseHeadersPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #responseHeadersPolicyConfig(ResponseHeadersPolicyConfig)}.
         * 
         * @param responseHeadersPolicyConfig
         *        a consumer that will call methods on {@link ResponseHeadersPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseHeadersPolicyConfig(ResponseHeadersPolicyConfig)
         */
        default Builder responseHeadersPolicyConfig(Consumer<ResponseHeadersPolicyConfig.Builder> responseHeadersPolicyConfig) {
            return responseHeadersPolicyConfig(ResponseHeadersPolicyConfig.builder().applyMutation(responseHeadersPolicyConfig)
                    .build());
        }

        /**
         * <p>
         * The identifier for the response headers policy that you are updating.
         * </p>
         * 
         * @param id
         *        The identifier for the response headers policy that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version of the response headers policy that you are updating.
         * </p>
         * <p>
         * The version is returned in the cache policy's <code>ETag</code> field in the response to
         * <code>GetResponseHeadersPolicyConfig</code>.
         * </p>
         * 
         * @param ifMatch
         *        The version of the response headers policy that you are updating.</p>
         *        <p>
         *        The version is returned in the cache policy's <code>ETag</code> field in the response to
         *        <code>GetResponseHeadersPolicyConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private ResponseHeadersPolicyConfig responseHeadersPolicyConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResponseHeadersPolicyRequest model) {
            super(model);
            responseHeadersPolicyConfig(model.responseHeadersPolicyConfig);
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final ResponseHeadersPolicyConfig.Builder getResponseHeadersPolicyConfig() {
            return responseHeadersPolicyConfig != null ? responseHeadersPolicyConfig.toBuilder() : null;
        }

        public final void setResponseHeadersPolicyConfig(ResponseHeadersPolicyConfig.BuilderImpl responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig != null ? responseHeadersPolicyConfig.build() : null;
        }

        @Override
        public final Builder responseHeadersPolicyConfig(ResponseHeadersPolicyConfig responseHeadersPolicyConfig) {
            this.responseHeadersPolicyConfig = responseHeadersPolicyConfig;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResponseHeadersPolicyRequest build() {
            return new UpdateResponseHeadersPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
