/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon CloudFront VPC origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcOrigin implements SdkPojo, Serializable, ToCopyableBuilder<VpcOrigin.Builder, VpcOrigin> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(VpcOrigin::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Arn")
            .getter(getter(VpcOrigin::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(VpcOrigin::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime")
            .getter(getter(VpcOrigin::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime")
                    .unmarshallLocationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(VpcOrigin::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime")
                    .unmarshallLocationName("LastModifiedTime").build()).build();

    private static final SdkField<VpcOriginEndpointConfig> VPC_ORIGIN_ENDPOINT_CONFIG_FIELD = SdkField
            .<VpcOriginEndpointConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcOriginEndpointConfig")
            .getter(getter(VpcOrigin::vpcOriginEndpointConfig))
            .setter(setter(Builder::vpcOriginEndpointConfig))
            .constructor(VpcOriginEndpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOriginEndpointConfig")
                    .unmarshallLocationName("VpcOriginEndpointConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            STATUS_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, VPC_ORIGIN_ENDPOINT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String status;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final VpcOriginEndpointConfig vpcOriginEndpointConfig;

    private VpcOrigin(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.vpcOriginEndpointConfig = builder.vpcOriginEndpointConfig;
    }

    /**
     * <p>
     * The VPC origin ID.
     * </p>
     * 
     * @return The VPC origin ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The VPC origin ARN.
     * </p>
     * 
     * @return The VPC origin ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The VPC origin status.
     * </p>
     * 
     * @return The VPC origin status.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The VPC origin created time.
     * </p>
     * 
     * @return The VPC origin created time.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The VPC origin last modified time.
     * </p>
     * 
     * @return The VPC origin last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The VPC origin endpoint configuration.
     * </p>
     * 
     * @return The VPC origin endpoint configuration.
     */
    public final VpcOriginEndpointConfig vpcOriginEndpointConfig() {
        return vpcOriginEndpointConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOriginEndpointConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOrigin)) {
            return false;
        }
        VpcOrigin other = (VpcOrigin) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(status(), other.status())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(vpcOriginEndpointConfig(), other.vpcOriginEndpointConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcOrigin").add("Id", id()).add("Arn", arn()).add("Status", status())
                .add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime())
                .add("VpcOriginEndpointConfig", vpcOriginEndpointConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "VpcOriginEndpointConfig":
            return Optional.ofNullable(clazz.cast(vpcOriginEndpointConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("VpcOriginEndpointConfig", VPC_ORIGIN_ENDPOINT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcOrigin, T> g) {
        return obj -> g.apply((VpcOrigin) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcOrigin> {
        /**
         * <p>
         * The VPC origin ID.
         * </p>
         * 
         * @param id
         *        The VPC origin ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The VPC origin ARN.
         * </p>
         * 
         * @param arn
         *        The VPC origin ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The VPC origin status.
         * </p>
         * 
         * @param status
         *        The VPC origin status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The VPC origin created time.
         * </p>
         * 
         * @param createdTime
         *        The VPC origin created time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The VPC origin last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The VPC origin last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The VPC origin endpoint configuration.
         * </p>
         * 
         * @param vpcOriginEndpointConfig
         *        The VPC origin endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOriginEndpointConfig(VpcOriginEndpointConfig vpcOriginEndpointConfig);

        /**
         * <p>
         * The VPC origin endpoint configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcOriginEndpointConfig.Builder} avoiding
         * the need to create one manually via {@link VpcOriginEndpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcOriginEndpointConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcOriginEndpointConfig(VpcOriginEndpointConfig)}.
         * 
         * @param vpcOriginEndpointConfig
         *        a consumer that will call methods on {@link VpcOriginEndpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOriginEndpointConfig(VpcOriginEndpointConfig)
         */
        default Builder vpcOriginEndpointConfig(Consumer<VpcOriginEndpointConfig.Builder> vpcOriginEndpointConfig) {
            return vpcOriginEndpointConfig(VpcOriginEndpointConfig.builder().applyMutation(vpcOriginEndpointConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private VpcOriginEndpointConfig vpcOriginEndpointConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOrigin model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            vpcOriginEndpointConfig(model.vpcOriginEndpointConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final VpcOriginEndpointConfig.Builder getVpcOriginEndpointConfig() {
            return vpcOriginEndpointConfig != null ? vpcOriginEndpointConfig.toBuilder() : null;
        }

        public final void setVpcOriginEndpointConfig(VpcOriginEndpointConfig.BuilderImpl vpcOriginEndpointConfig) {
            this.vpcOriginEndpointConfig = vpcOriginEndpointConfig != null ? vpcOriginEndpointConfig.build() : null;
        }

        @Override
        public final Builder vpcOriginEndpointConfig(VpcOriginEndpointConfig vpcOriginEndpointConfig) {
            this.vpcOriginEndpointConfig = vpcOriginEndpointConfig;
            return this;
        }

        @Override
        public VpcOrigin build() {
            return new VpcOrigin(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
