/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CachedMethods;
import software.amazon.awssdk.services.cloudfront.model.Method;
import software.amazon.awssdk.services.cloudfront.model.MethodsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AllowedMethods
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AllowedMethods> {
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Quantity").getter(AllowedMethods.getter(AllowedMethods::quantity)).setter(AllowedMethods.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("Quantity").build()}).build();
    private static final SdkField<List<String>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(AllowedMethods.getter(AllowedMethods::itemsAsStrings)).setter(AllowedMethods.setter(Builder::itemsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName("Method").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").unmarshallLocationName("Method").build()}).build()).build()}).build();
    private static final SdkField<CachedMethods> CACHED_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CachedMethods").getter(AllowedMethods.getter(AllowedMethods::cachedMethods)).setter(AllowedMethods.setter(Builder::cachedMethods)).constructor(CachedMethods::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachedMethods").unmarshallLocationName("CachedMethods").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTITY_FIELD, ITEMS_FIELD, CACHED_METHODS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AllowedMethods.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer quantity;
    private final List<String> items;
    private final CachedMethods cachedMethods;

    private AllowedMethods(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
        this.cachedMethods = builder.cachedMethods;
    }

    public final Integer quantity() {
        return this.quantity;
    }

    public final List<Method> items() {
        return MethodsListCopier.copyStringToEnum(this.items);
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<String> itemsAsStrings() {
        return this.items;
    }

    public final CachedMethods cachedMethods() {
        return this.cachedMethods;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.itemsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cachedMethods());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedMethods)) {
            return false;
        }
        AllowedMethods other = (AllowedMethods)obj;
        return Objects.equals(this.quantity(), other.quantity()) && this.hasItems() == other.hasItems() && Objects.equals(this.itemsAsStrings(), other.itemsAsStrings()) && Objects.equals(this.cachedMethods(), other.cachedMethods());
    }

    public final String toString() {
        return ToString.builder((String)"AllowedMethods").add("Quantity", (Object)this.quantity()).add("Items", this.hasItems() ? this.itemsAsStrings() : null).add("CachedMethods", (Object)this.cachedMethods()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.itemsAsStrings()));
            }
            case "CachedMethods": {
                return Optional.ofNullable(clazz.cast(this.cachedMethods()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Quantity", QUANTITY_FIELD);
        map.put("Items", ITEMS_FIELD);
        map.put("CachedMethods", CACHED_METHODS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllowedMethods, T> g) {
        return obj -> g.apply((AllowedMethods)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<String> items = DefaultSdkAutoConstructList.getInstance();
        private CachedMethods cachedMethods;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowedMethods model) {
            this.quantity(model.quantity);
            this.itemsWithStrings(model.items);
            this.cachedMethods(model.cachedMethods);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final Collection<String> getItems() {
            if (this.items instanceof SdkAutoConstructList) {
                return null;
            }
            return this.items;
        }

        public final void setItems(Collection<String> items) {
            this.items = MethodsListCopier.copy(items);
        }

        @Override
        public final Builder itemsWithStrings(Collection<String> items) {
            this.items = MethodsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemsWithStrings(String ... items) {
            this.itemsWithStrings(Arrays.asList(items));
            return this;
        }

        @Override
        public final Builder items(Collection<Method> items) {
            this.items = MethodsListCopier.copyEnumToString(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Method ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        public final CachedMethods.Builder getCachedMethods() {
            return this.cachedMethods != null ? this.cachedMethods.toBuilder() : null;
        }

        public final void setCachedMethods(CachedMethods.BuilderImpl cachedMethods) {
            this.cachedMethods = cachedMethods != null ? cachedMethods.build() : null;
        }

        @Override
        public final Builder cachedMethods(CachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
            return this;
        }

        public AllowedMethods build() {
            return new AllowedMethods(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AllowedMethods> {
        public Builder quantity(Integer var1);

        public Builder itemsWithStrings(Collection<String> var1);

        public Builder itemsWithStrings(String ... var1);

        public Builder items(Collection<Method> var1);

        public Builder items(Method ... var1);

        public Builder cachedMethods(CachedMethods var1);

        default public Builder cachedMethods(Consumer<CachedMethods.Builder> cachedMethods) {
            return this.cachedMethods((CachedMethods)((CachedMethods.Builder)CachedMethods.builder().applyMutation(cachedMethods)).build());
        }
    }
}

