/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DomainConflict;
import software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsResponse;

public class ListDomainConflictsIterable
implements SdkIterable<ListDomainConflictsResponse> {
    private final CloudFrontClient client;
    private final ListDomainConflictsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainConflictsIterable(CloudFrontClient client, ListDomainConflictsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainConflictsResponseFetcher();
    }

    public Iterator<ListDomainConflictsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainConflict> domainConflicts() {
        Function<ListDomainConflictsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domainConflicts() != null) {
                return response.domainConflicts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainConflictsResponseFetcher
    implements SyncPageFetcher<ListDomainConflictsResponse> {
        private ListDomainConflictsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainConflictsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListDomainConflictsResponse nextPage(ListDomainConflictsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainConflictsIterable.this.client.listDomainConflicts(ListDomainConflictsIterable.this.firstRequest);
            }
            return ListDomainConflictsIterable.this.client.listDomainConflicts((ListDomainConflictsRequest)((Object)ListDomainConflictsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

