/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSummary;

public class ListOriginAccessControlsPublisher
implements SdkPublisher<ListOriginAccessControlsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListOriginAccessControlsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOriginAccessControlsPublisher(CloudFrontAsyncClient client, ListOriginAccessControlsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOriginAccessControlsPublisher(CloudFrontAsyncClient client, ListOriginAccessControlsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOriginAccessControlsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOriginAccessControlsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OriginAccessControlSummary> items() {
        Function<ListOriginAccessControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.originAccessControlList() != null && response.originAccessControlList().items() != null) {
                return response.originAccessControlList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOriginAccessControlsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOriginAccessControlsResponseFetcher
    implements AsyncPageFetcher<ListOriginAccessControlsResponse> {
        private ListOriginAccessControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListOriginAccessControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.originAccessControlList().nextMarker());
        }

        public CompletableFuture<ListOriginAccessControlsResponse> nextPage(ListOriginAccessControlsResponse previousPage) {
            if (previousPage == null) {
                return ListOriginAccessControlsPublisher.this.client.listOriginAccessControls(ListOriginAccessControlsPublisher.this.firstRequest);
            }
            return ListOriginAccessControlsPublisher.this.client.listOriginAccessControls((ListOriginAccessControlsRequest)((Object)ListOriginAccessControlsPublisher.this.firstRequest.toBuilder().marker(previousPage.originAccessControlList().nextMarker()).build()));
        }
    }
}

