/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSubscriptionFiltersResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<DescribeSubscriptionFiltersResponse.Builder, DescribeSubscriptionFiltersResponse> {
    private static final SdkField<List<SubscriptionFilter>> SUBSCRIPTION_FILTERS_FIELD = SdkField
            .<List<SubscriptionFilter>> builder(MarshallingType.LIST)
            .memberName("subscriptionFilters")
            .getter(getter(DescribeSubscriptionFiltersResponse::subscriptionFilters))
            .setter(setter(Builder::subscriptionFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscriptionFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscriptionFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeSubscriptionFiltersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_FILTERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SubscriptionFilter> subscriptionFilters;

    private final String nextToken;

    private DescribeSubscriptionFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.subscriptionFilters = builder.subscriptionFilters;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SubscriptionFilters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSubscriptionFilters() {
        return subscriptionFilters != null && !(subscriptionFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subscription filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubscriptionFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The subscription filters.
     */
    public final List<SubscriptionFilter> subscriptionFilters() {
        return subscriptionFilters;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscriptionFilters() ? subscriptionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubscriptionFiltersResponse)) {
            return false;
        }
        DescribeSubscriptionFiltersResponse other = (DescribeSubscriptionFiltersResponse) obj;
        return hasSubscriptionFilters() == other.hasSubscriptionFilters()
                && Objects.equals(subscriptionFilters(), other.subscriptionFilters())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSubscriptionFiltersResponse")
                .add("SubscriptionFilters", hasSubscriptionFilters() ? subscriptionFilters() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subscriptionFilters":
            return Optional.ofNullable(clazz.cast(subscriptionFilters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubscriptionFiltersResponse, T> g) {
        return obj -> g.apply((DescribeSubscriptionFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSubscriptionFiltersResponse> {
        /**
         * <p>
         * The subscription filters.
         * </p>
         * 
         * @param subscriptionFilters
         *        The subscription filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionFilters(Collection<SubscriptionFilter> subscriptionFilters);

        /**
         * <p>
         * The subscription filters.
         * </p>
         * 
         * @param subscriptionFilters
         *        The subscription filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionFilters(SubscriptionFilter... subscriptionFilters);

        /**
         * <p>
         * The subscription filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SubscriptionFilter>.Builder} avoiding the
         * need to create one manually via {@link List<SubscriptionFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubscriptionFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #subscriptionFilters(List<SubscriptionFilter>)}.
         * 
         * @param subscriptionFilters
         *        a consumer that will call methods on {@link List<SubscriptionFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscriptionFilters(List<SubscriptionFilter>)
         */
        Builder subscriptionFilters(Consumer<SubscriptionFilter.Builder>... subscriptionFilters);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<SubscriptionFilter> subscriptionFilters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubscriptionFiltersResponse model) {
            super(model);
            subscriptionFilters(model.subscriptionFilters);
            nextToken(model.nextToken);
        }

        public final Collection<SubscriptionFilter.Builder> getSubscriptionFilters() {
            if (subscriptionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return subscriptionFilters != null ? subscriptionFilters.stream().map(SubscriptionFilter::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscriptionFilters(Collection<SubscriptionFilter> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copy(subscriptionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionFilters(SubscriptionFilter... subscriptionFilters) {
            subscriptionFilters(Arrays.asList(subscriptionFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionFilters(Consumer<SubscriptionFilter.Builder>... subscriptionFilters) {
            subscriptionFilters(Stream.of(subscriptionFilters).map(c -> SubscriptionFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSubscriptionFilters(Collection<SubscriptionFilter.BuilderImpl> subscriptionFilters) {
            this.subscriptionFilters = SubscriptionFiltersCopier.copyFromBuilder(subscriptionFilters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSubscriptionFiltersResponse build() {
            return new DescribeSubscriptionFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
