/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sequence token is not valid. You can get the correct sequence token in the <code>expectedSequenceToken</code>
 * field in the <code>InvalidSequenceTokenException</code> message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidSequenceTokenException extends CloudWatchLogsException implements
        ToCopyableBuilder<InvalidSequenceTokenException.Builder, InvalidSequenceTokenException> {
    private static final SdkField<String> EXPECTED_SEQUENCE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedSequenceToken").getter(getter(InvalidSequenceTokenException::expectedSequenceToken))
            .setter(setter(Builder::expectedSequenceToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedSequenceToken").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EXPECTED_SEQUENCE_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String expectedSequenceToken;

    private InvalidSequenceTokenException(BuilderImpl builder) {
        super(builder);
        this.expectedSequenceToken = builder.expectedSequenceToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ExpectedSequenceToken property for this object.
     * 
     * @return The value of the ExpectedSequenceToken property for this object.
     */
    public String expectedSequenceToken() {
        return expectedSequenceToken;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidSequenceTokenException, T> g) {
        return obj -> g.apply((InvalidSequenceTokenException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidSequenceTokenException>,
            CloudWatchLogsException.Builder {
        /**
         * Sets the value of the ExpectedSequenceToken property for this object.
         *
         * @param expectedSequenceToken
         *        The new value for the ExpectedSequenceToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedSequenceToken(String expectedSequenceToken);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends CloudWatchLogsException.BuilderImpl implements Builder {
        private String expectedSequenceToken;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidSequenceTokenException model) {
            super(model);
            expectedSequenceToken(model.expectedSequenceToken);
        }

        public final String getExpectedSequenceToken() {
            return expectedSequenceToken;
        }

        public final void setExpectedSequenceToken(String expectedSequenceToken) {
            this.expectedSequenceToken = expectedSequenceToken;
        }

        @Override
        @Transient
        public final Builder expectedSequenceToken(String expectedSequenceToken) {
            this.expectedSequenceToken = expectedSequenceToken;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidSequenceTokenException build() {
            return new InvalidSequenceTokenException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
