/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutLogEventsRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutLogEventsRequest.Builder, PutLogEventsRequest> {
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroupName").getter(getter(PutLogEventsRequest::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()).build();

    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamName").getter(getter(PutLogEventsRequest::logStreamName))
            .setter(setter(Builder::logStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()).build();

    private static final SdkField<List<InputLogEvent>> LOG_EVENTS_FIELD = SdkField
            .<List<InputLogEvent>> builder(MarshallingType.LIST)
            .memberName("logEvents")
            .getter(getter(PutLogEventsRequest::logEvents))
            .setter(setter(Builder::logEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputLogEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputLogEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SEQUENCE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceToken").getter(getter(PutLogEventsRequest::sequenceToken))
            .setter(setter(Builder::sequenceToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_NAME_FIELD,
            LOG_STREAM_NAME_FIELD, LOG_EVENTS_FIELD, SEQUENCE_TOKEN_FIELD));

    private final String logGroupName;

    private final String logStreamName;

    private final List<InputLogEvent> logEvents;

    private final String sequenceToken;

    private PutLogEventsRequest(BuilderImpl builder) {
        super(builder);
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
        this.logEvents = builder.logEvents;
        this.sequenceToken = builder.sequenceToken;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The name of the log stream.
     * </p>
     * 
     * @return The name of the log stream.
     */
    public final String logStreamName() {
        return logStreamName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogEvents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogEvents() {
        return logEvents != null && !(logEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogEvents} method.
     * </p>
     * 
     * @return The log events.
     */
    public final List<InputLogEvent> logEvents() {
        return logEvents;
    }

    /**
     * <p>
     * The sequence token obtained from the response of the previous <code>PutLogEvents</code> call. An upload in a
     * newly created log stream does not require a sequence token. You can also get the sequence token using <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogStreams.html"
     * >DescribeLogStreams</a>. If you call <code>PutLogEvents</code> twice within a narrow time period using the same
     * value for <code>sequenceToken</code>, both calls might be successful or one might be rejected.
     * </p>
     * 
     * @return The sequence token obtained from the response of the previous <code>PutLogEvents</code> call. An upload
     *         in a newly created log stream does not require a sequence token. You can also get the sequence token
     *         using <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogStreams.html"
     *         >DescribeLogStreams</a>. If you call <code>PutLogEvents</code> twice within a narrow time period using
     *         the same value for <code>sequenceToken</code>, both calls might be successful or one might be rejected.
     */
    public final String sequenceToken() {
        return sequenceToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogEvents() ? logEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sequenceToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLogEventsRequest)) {
            return false;
        }
        PutLogEventsRequest other = (PutLogEventsRequest) obj;
        return Objects.equals(logGroupName(), other.logGroupName()) && Objects.equals(logStreamName(), other.logStreamName())
                && hasLogEvents() == other.hasLogEvents() && Objects.equals(logEvents(), other.logEvents())
                && Objects.equals(sequenceToken(), other.sequenceToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutLogEventsRequest").add("LogGroupName", logGroupName()).add("LogStreamName", logStreamName())
                .add("LogEvents", hasLogEvents() ? logEvents() : null).add("SequenceToken", sequenceToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "logStreamName":
            return Optional.ofNullable(clazz.cast(logStreamName()));
        case "logEvents":
            return Optional.ofNullable(clazz.cast(logEvents()));
        case "sequenceToken":
            return Optional.ofNullable(clazz.cast(sequenceToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLogEventsRequest, T> g) {
        return obj -> g.apply((PutLogEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutLogEventsRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The name of the log stream.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The log events.
         * </p>
         * 
         * @param logEvents
         *        The log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEvents(Collection<InputLogEvent> logEvents);

        /**
         * <p>
         * The log events.
         * </p>
         * 
         * @param logEvents
         *        The log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEvents(InputLogEvent... logEvents);

        /**
         * <p>
         * The log events.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InputLogEvent>.Builder} avoiding the need
         * to create one manually via {@link List<InputLogEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputLogEvent>.Builder#build()} is called immediately and
         * its result is passed to {@link #logEvents(List<InputLogEvent>)}.
         * 
         * @param logEvents
         *        a consumer that will call methods on {@link List<InputLogEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logEvents(List<InputLogEvent>)
         */
        Builder logEvents(Consumer<InputLogEvent.Builder>... logEvents);

        /**
         * <p>
         * The sequence token obtained from the response of the previous <code>PutLogEvents</code> call. An upload in a
         * newly created log stream does not require a sequence token. You can also get the sequence token using <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogStreams.html">
         * DescribeLogStreams</a>. If you call <code>PutLogEvents</code> twice within a narrow time period using the
         * same value for <code>sequenceToken</code>, both calls might be successful or one might be rejected.
         * </p>
         * 
         * @param sequenceToken
         *        The sequence token obtained from the response of the previous <code>PutLogEvents</code> call. An
         *        upload in a newly created log stream does not require a sequence token. You can also get the sequence
         *        token using <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogStreams.html"
         *        >DescribeLogStreams</a>. If you call <code>PutLogEvents</code> twice within a narrow time period using
         *        the same value for <code>sequenceToken</code>, both calls might be successful or one might be
         *        rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceToken(String sequenceToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String logGroupName;

        private String logStreamName;

        private List<InputLogEvent> logEvents = DefaultSdkAutoConstructList.getInstance();

        private String sequenceToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLogEventsRequest model) {
            super(model);
            logGroupName(model.logGroupName);
            logStreamName(model.logStreamName);
            logEvents(model.logEvents);
            sequenceToken(model.sequenceToken);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        @Transient
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        @Transient
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final List<InputLogEvent.Builder> getLogEvents() {
            List<InputLogEvent.Builder> result = InputLogEventsCopier.copyToBuilder(this.logEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogEvents(Collection<InputLogEvent.BuilderImpl> logEvents) {
            this.logEvents = InputLogEventsCopier.copyFromBuilder(logEvents);
        }

        @Override
        @Transient
        public final Builder logEvents(Collection<InputLogEvent> logEvents) {
            this.logEvents = InputLogEventsCopier.copy(logEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logEvents(InputLogEvent... logEvents) {
            logEvents(Arrays.asList(logEvents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logEvents(Consumer<InputLogEvent.Builder>... logEvents) {
            logEvents(Stream.of(logEvents).map(c -> InputLogEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSequenceToken() {
            return sequenceToken;
        }

        public final void setSequenceToken(String sequenceToken) {
            this.sequenceToken = sequenceToken;
        }

        @Override
        @Transient
        public final Builder sequenceToken(String sequenceToken) {
            this.sequenceToken = sequenceToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutLogEventsRequest build() {
            return new PutLogEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
