/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PackageFormat {
    NPM("npm"),
    PYPI("pypi"),
    MAVEN("maven"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PackageFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PackageFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageFormat> knownValues() {
        return Stream.of(PackageFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

