/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionListCopier;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionRevisionMapCopier;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePackageVersionsStatusRequest
extends CodeartifactRequest
implements ToCopyableBuilder<Builder, UpdatePackageVersionsStatusRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::domain)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain").build()}).build();
    private static final SdkField<String> DOMAIN_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::domainOwner)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::domainOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domain-owner").build()}).build();
    private static final SdkField<String> REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::repository)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::repository)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("repository").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::formatAsString)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::namespace)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::packageValue)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("package").build()}).build();
    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::versions)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> VERSION_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::versionRevisions)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::versionRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevisions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> EXPECTED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::expectedStatusAsString)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::expectedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedStatus").build()}).build();
    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdatePackageVersionsStatusRequest.getter(UpdatePackageVersionsStatusRequest::targetStatusAsString)).setter(UpdatePackageVersionsStatusRequest.setter(Builder::targetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, DOMAIN_OWNER_FIELD, REPOSITORY_FIELD, FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, VERSIONS_FIELD, VERSION_REVISIONS_FIELD, EXPECTED_STATUS_FIELD, TARGET_STATUS_FIELD));
    private final String domain;
    private final String domainOwner;
    private final String repository;
    private final String format;
    private final String namespace;
    private final String packageValue;
    private final List<String> versions;
    private final Map<String, String> versionRevisions;
    private final String expectedStatus;
    private final String targetStatus;

    private UpdatePackageVersionsStatusRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.domainOwner = builder.domainOwner;
        this.repository = builder.repository;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.versions = builder.versions;
        this.versionRevisions = builder.versionRevisions;
        this.expectedStatus = builder.expectedStatus;
        this.targetStatus = builder.targetStatus;
    }

    public String domain() {
        return this.domain;
    }

    public String domainOwner() {
        return this.domainOwner;
    }

    public String repository() {
        return this.repository;
    }

    public PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String namespace() {
        return this.namespace;
    }

    public String packageValue() {
        return this.packageValue;
    }

    public boolean hasVersions() {
        return this.versions != null && !(this.versions instanceof SdkAutoConstructList);
    }

    public List<String> versions() {
        return this.versions;
    }

    public boolean hasVersionRevisions() {
        return this.versionRevisions != null && !(this.versionRevisions instanceof SdkAutoConstructMap);
    }

    public Map<String, String> versionRevisions() {
        return this.versionRevisions;
    }

    public PackageVersionStatus expectedStatus() {
        return PackageVersionStatus.fromValue(this.expectedStatus);
    }

    public String expectedStatusAsString() {
        return this.expectedStatus;
    }

    public PackageVersionStatus targetStatus() {
        return PackageVersionStatus.fromValue(this.targetStatus);
    }

    public String targetStatusAsString() {
        return this.targetStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.repository());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionRevisions());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageVersionsStatusRequest)) {
            return false;
        }
        UpdatePackageVersionsStatusRequest other = (UpdatePackageVersionsStatusRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainOwner(), other.domainOwner()) && Objects.equals(this.repository(), other.repository()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageValue(), other.packageValue()) && Objects.equals(this.versions(), other.versions()) && Objects.equals(this.versionRevisions(), other.versionRevisions()) && Objects.equals(this.expectedStatusAsString(), other.expectedStatusAsString()) && Objects.equals(this.targetStatusAsString(), other.targetStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePackageVersionsStatusRequest").add("Domain", (Object)this.domain()).add("DomainOwner", (Object)this.domainOwner()).add("Repository", (Object)this.repository()).add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("Package", (Object)this.packageValue()).add("Versions", this.versions()).add("VersionRevisions", this.versionRevisions()).add("ExpectedStatus", (Object)this.expectedStatusAsString()).add("TargetStatus", (Object)this.targetStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "domainOwner": {
                return Optional.ofNullable(clazz.cast(this.domainOwner()));
            }
            case "repository": {
                return Optional.ofNullable(clazz.cast(this.repository()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
            case "versionRevisions": {
                return Optional.ofNullable(clazz.cast(this.versionRevisions()));
            }
            case "expectedStatus": {
                return Optional.ofNullable(clazz.cast(this.expectedStatusAsString()));
            }
            case "targetStatus": {
                return Optional.ofNullable(clazz.cast(this.targetStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageVersionsStatusRequest, T> g) {
        return obj -> g.apply((UpdatePackageVersionsStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactRequest.BuilderImpl
    implements Builder {
        private String domain;
        private String domainOwner;
        private String repository;
        private String format;
        private String namespace;
        private String packageValue;
        private List<String> versions = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> versionRevisions = DefaultSdkAutoConstructMap.getInstance();
        private String expectedStatus;
        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageVersionsStatusRequest model) {
            super(model);
            this.domain(model.domain);
            this.domainOwner(model.domainOwner);
            this.repository(model.repository);
            this.format(model.format);
            this.namespace(model.namespace);
            this.packageValue(model.packageValue);
            this.versions(model.versions);
            this.versionRevisions(model.versionRevisions);
            this.expectedStatus(model.expectedStatus);
            this.targetStatus(model.targetStatus);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getDomainOwner() {
            return this.domainOwner;
        }

        @Override
        public final Builder domainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        public final void setDomainOwner(String domainOwner) {
            this.domainOwner = domainOwner;
        }

        public final String getRepository() {
            return this.repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        public final Collection<String> getVersions() {
            return this.versions;
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = PackageVersionListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = PackageVersionListCopier.copy(versions);
        }

        public final Map<String, String> getVersionRevisions() {
            return this.versionRevisions;
        }

        @Override
        public final Builder versionRevisions(Map<String, String> versionRevisions) {
            this.versionRevisions = PackageVersionRevisionMapCopier.copy(versionRevisions);
            return this;
        }

        public final void setVersionRevisions(Map<String, String> versionRevisions) {
            this.versionRevisions = PackageVersionRevisionMapCopier.copy(versionRevisions);
        }

        public final String getExpectedStatus() {
            return this.expectedStatus;
        }

        @Override
        public final Builder expectedStatus(String expectedStatus) {
            this.expectedStatus = expectedStatus;
            return this;
        }

        @Override
        public final Builder expectedStatus(PackageVersionStatus expectedStatus) {
            this.expectedStatus(expectedStatus == null ? null : expectedStatus.toString());
            return this;
        }

        public final void setExpectedStatus(String expectedStatus) {
            this.expectedStatus = expectedStatus;
        }

        public final String getTargetStatus() {
            return this.targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(PackageVersionStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageVersionsStatusRequest build() {
            return new UpdatePackageVersionsStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePackageVersionsStatusRequest> {
        public Builder domain(String var1);

        public Builder domainOwner(String var1);

        public Builder repository(String var1);

        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder packageValue(String var1);

        public Builder versions(Collection<String> var1);

        public Builder versions(String ... var1);

        public Builder versionRevisions(Map<String, String> var1);

        public Builder expectedStatus(String var1);

        public Builder expectedStatus(PackageVersionStatus var1);

        public Builder targetStatus(String var1);

        public Builder targetStatus(PackageVersionStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

