/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactAsyncClient;
import software.amazon.awssdk.services.codeartifact.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeartifact.model.ListAllowedRepositoriesForGroupRequest;
import software.amazon.awssdk.services.codeartifact.model.ListAllowedRepositoriesForGroupResponse;

public class ListAllowedRepositoriesForGroupPublisher
implements SdkPublisher<ListAllowedRepositoriesForGroupResponse> {
    private final CodeartifactAsyncClient client;
    private final ListAllowedRepositoriesForGroupRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAllowedRepositoriesForGroupPublisher(CodeartifactAsyncClient client, ListAllowedRepositoriesForGroupRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAllowedRepositoriesForGroupPublisher(CodeartifactAsyncClient client, ListAllowedRepositoriesForGroupRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAllowedRepositoriesForGroupResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAllowedRepositoriesForGroupResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> allowedRepositories() {
        Function<ListAllowedRepositoriesForGroupResponse, Iterator> getIterator = response -> {
            if (response != null && response.allowedRepositories() != null) {
                return response.allowedRepositories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAllowedRepositoriesForGroupResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAllowedRepositoriesForGroupResponseFetcher
    implements AsyncPageFetcher<ListAllowedRepositoriesForGroupResponse> {
        private ListAllowedRepositoriesForGroupResponseFetcher() {
        }

        public boolean hasNextPage(ListAllowedRepositoriesForGroupResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAllowedRepositoriesForGroupResponse> nextPage(ListAllowedRepositoriesForGroupResponse previousPage) {
            if (previousPage == null) {
                return ListAllowedRepositoriesForGroupPublisher.this.client.listAllowedRepositoriesForGroup(ListAllowedRepositoriesForGroupPublisher.this.firstRequest);
            }
            return ListAllowedRepositoriesForGroupPublisher.this.client.listAllowedRepositoriesForGroup((ListAllowedRepositoriesForGroupRequest)((Object)ListAllowedRepositoriesForGroupPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

